/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.internal.Actions;
import org.gradle.model.internal.inspect.FormattingValidationProblemCollector;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.type.ModelType;
import org.jspecify.annotations.Nullable;

public class DefaultModelSchemaExtractionContext<T>
implements ModelSchemaExtractionContext<T> {
    private final DefaultModelSchemaExtractionContext<?> parent;
    private final ModelType<T> type;
    private final String description;
    private final Action<? super ModelSchema<T>> validator;
    private ModelSchema<T> result;
    private final List<DefaultModelSchemaExtractionContext<?>> children = new ArrayList();
    private final FormattingValidationProblemCollector problems;

    private DefaultModelSchemaExtractionContext(DefaultModelSchemaExtractionContext<?> parent, ModelType<T> type, String description, Action<? super ModelSchema<T>> validator) {
        this.parent = parent;
        this.type = type;
        this.description = description;
        this.problems = new FormattingValidationProblemCollector("model element type", type);
        this.validator = validator;
    }

    public static <T> DefaultModelSchemaExtractionContext<T> root(ModelType<T> type) {
        return new DefaultModelSchemaExtractionContext<T>(null, type, null, null);
    }

    public @Nullable DefaultModelSchemaExtractionContext<?> getParent() {
        return this.parent;
    }

    @Override
    public ModelType<T> getType() {
        return this.type;
    }

    public FormattingValidationProblemCollector getProblems() {
        return this.problems;
    }

    @Override
    public boolean hasProblems() {
        return this.problems.hasProblems();
    }

    @Override
    public void add(String problem) {
        this.problems.add(problem);
    }

    @Override
    public void add(Field field, String problem) {
        this.problems.add(field, problem);
    }

    @Override
    public void add(Method method, String role, String problem) {
        this.problems.add(method, role, problem);
    }

    @Override
    public void add(Method method, String problem) {
        this.add(method, null, problem);
    }

    @Override
    public void add(Constructor<?> constructor, String problem) {
        this.problems.add(constructor, problem);
    }

    public String getDescription() {
        return this.description == null ? this.type.toString() : this.description + " (" + this.type + ")";
    }

    public List<DefaultModelSchemaExtractionContext<?>> getChildren() {
        return this.children;
    }

    @Override
    public <C> DefaultModelSchemaExtractionContext<C> child(ModelType<C> type, String description) {
        return this.child((ModelType)type, description, Actions.doNothing());
    }

    @Override
    public <C> DefaultModelSchemaExtractionContext<C> child(ModelType<C> type, String description, Action<? super ModelSchema<C>> validator) {
        DefaultModelSchemaExtractionContext<C> childContext = new DefaultModelSchemaExtractionContext<C>(this, type, description, validator);
        this.children.add(childContext);
        return childContext;
    }

    public @Nullable ModelSchema<T> getResult() {
        return this.result;
    }

    @Override
    public void found(ModelSchema<T> result) {
        this.result = result;
    }

    public void validate(ModelSchema<T> schema) {
        if (this.validator != null) {
            this.validator.execute(schema);
        }
    }
}

