/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.text;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtilRt {
    @Contract(value="null,!null,_ -> false; !null,null,_ -> false; null,null,_ -> true")
    public static boolean equal(@Nullable CharSequence s1, @Nullable CharSequence s2, boolean caseSensitive) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        if (caseSensitive) {
            for (int i2 = 0; i2 < s1.length(); ++i2) {
                if (s1.charAt(i2) == s2.charAt(i2)) continue;
                return false;
            }
        } else {
            for (int i3 = 0; i3 < s1.length(); ++i3) {
                if (StringUtilRt.charsEqualIgnoreCase(s1.charAt(i3), s2.charAt(i3))) continue;
                return false;
            }
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a2, char b2) {
        return a2 == b2 || StringUtilRt.toUpperCase(a2) == StringUtilRt.toUpperCase(b2) || StringUtilRt.toLowerCase(a2) == StringUtilRt.toLowerCase(b2);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a2) {
        if (a2 < 'a') {
            return a2;
        }
        if (a2 <= 'z') {
            return (char)(a2 + -32);
        }
        return Character.toUpperCase(a2);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a2) {
        if (a2 <= 'z') {
            return a2 >= 'A' && a2 <= 'Z' ? (char)(a2 + 32) : a2;
        }
        return Character.toLowerCase(a2);
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(0);
        }
        return StringUtilRt.convertLineSeparators(text, false);
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text, boolean keepCarriageReturn) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(1);
        }
        return StringUtilRt.convertLineSeparators(text, "\n", null, keepCarriageReturn);
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(2);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(3);
        }
        return StringUtilRt.convertLineSeparators(text, newSeparator, null);
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence convertLineSeparators(@NotNull CharSequence text, @NotNull String newSeparator) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(4);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(5);
        }
        return StringUtilRt.unifyLineSeparators(text, newSeparator, null, false);
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(6);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(7);
        }
        return StringUtilRt.convertLineSeparators(text, newSeparator, offsetsToKeep, false);
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep, boolean keepCarriageReturn) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(8);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(9);
        }
        String string = StringUtilRt.unifyLineSeparators(text, newSeparator, offsetsToKeep, keepCarriageReturn).toString();
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static CharSequence unifyLineSeparators(@NotNull CharSequence text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep, boolean keepCarriageReturn) {
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(11);
        }
        if (newSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(12);
        }
        StringBuilder buffer = null;
        int intactLength = 0;
        boolean newSeparatorIsSlashN = "\n".equals(newSeparator);
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c2 = text.charAt(i2);
            if (c2 == '\n') {
                if (!newSeparatorIsSlashN) {
                    if (buffer == null) {
                        buffer = new StringBuilder(text.length());
                        buffer.append(text, 0, intactLength);
                    }
                    buffer.append(newSeparator);
                    StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                    continue;
                }
                if (buffer == null) {
                    ++intactLength;
                    continue;
                }
                buffer.append('\n');
                continue;
            }
            if (c2 == '\r') {
                boolean followedByLineFeed;
                boolean bl = followedByLineFeed = i2 < text.length() - 1 && text.charAt(i2 + 1) == '\n';
                if (!followedByLineFeed && keepCarriageReturn) {
                    if (buffer == null) {
                        ++intactLength;
                        continue;
                    }
                    buffer.append('\r');
                    continue;
                }
                if (buffer == null) {
                    buffer = new StringBuilder(text.length());
                    buffer.append(text, 0, intactLength);
                }
                buffer.append(newSeparator);
                if (followedByLineFeed) {
                    ++i2;
                    StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 2, newSeparator.length());
                    continue;
                }
                StringUtilRt.shiftOffsets(offsetsToKeep, buffer.length(), 1, newSeparator.length());
                continue;
            }
            if (buffer == null) {
                ++intactLength;
                continue;
            }
            buffer.append(c2);
        }
        CharSequence charSequence = buffer == null ? text : buffer;
        if (charSequence == null) {
            StringUtilRt.$$$reportNull$$$0(13);
        }
        return charSequence;
    }

    private static void shiftOffsets(int[] offsets, int changeOffset, int oldLength, int newLength) {
        if (offsets == null) {
            return;
        }
        int shift = newLength - oldLength;
        if (shift == 0) {
            return;
        }
        for (int i2 = 0; i2 < offsets.length; ++i2) {
            int offset = offsets[i2];
            if (offset < changeOffset + oldLength) continue;
            int n2 = i2;
            offsets[n2] = offsets[n2] + shift;
        }
    }

    @Contract(pure=true)
    public static int parseInt(@Nullable String string, int defaultValue) {
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Contract(pure=true)
    public static long parseLong(@Nullable String string, long defaultValue) {
        if (string != null) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Contract(pure=true)
    public static double parseDouble(@Nullable String string, double defaultValue) {
        if (string != null) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Contract(pure=true)
    static <E extends Enum<E>> E parseEnum(@NotNull String string, E defaultValue, @NotNull Class<E> clazz) {
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(14);
        }
        if (clazz == null) {
            StringUtilRt.$$$reportNull$$$0(15);
        }
        try {
            return Enum.valueOf(clazz, string);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull Class<?> aClass) {
        if (aClass == null) {
            StringUtilRt.$$$reportNull$$$0(16);
        }
        return StringUtilRt.getShortName(aClass.getName());
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName) {
        if (fqName == null) {
            StringUtilRt.$$$reportNull$$$0(17);
        }
        return StringUtilRt.getShortName(fqName, '.');
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName, char separator) {
        int lastPointIdx;
        if (fqName == null) {
            StringUtilRt.$$$reportNull$$$0(18);
        }
        if ((lastPointIdx = fqName.lastIndexOf(separator)) >= 0) {
            String string = fqName.substring(lastPointIdx + 1);
            if (string == null) {
                StringUtilRt.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = fqName;
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s2, char suffix) {
        return s2 != null && s2.length() != 0 && s2.charAt(s2.length() - 1) == suffix;
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        int l2;
        int l1;
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(21);
        }
        if (suffix == null) {
            StringUtilRt.$$$reportNull$$$0(22);
        }
        if ((l1 = text.length()) < (l2 = suffix.length())) {
            return false;
        }
        for (int i2 = l1 - 1; i2 >= l1 - l2; --i2) {
            if (text.charAt(i2) == suffix.charAt(i2 + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NotNull String str, @NotNull String prefix) {
        if (str == null) {
            StringUtilRt.$$$reportNull$$$0(23);
        }
        if (prefix == null) {
            StringUtilRt.$$$reportNull$$$0(24);
        }
        return StringUtilRt.startsWithIgnoreCase(str, 0, prefix);
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NotNull String str, int startOffset, @NotNull String prefix) {
        int prefixLength;
        int stringLength;
        if (str == null) {
            StringUtilRt.$$$reportNull$$$0(25);
        }
        if (prefix == null) {
            StringUtilRt.$$$reportNull$$$0(26);
        }
        return (stringLength = str.length()) >= (prefixLength = prefix.length()) && str.regionMatches(true, startOffset, prefix, 0, prefixLength);
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        int l2;
        int l1;
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(27);
        }
        if (suffix == null) {
            StringUtilRt.$$$reportNull$$$0(28);
        }
        if ((l1 = text.length()) < (l2 = suffix.length())) {
            return false;
        }
        for (int i2 = l1 - 1; i2 >= l1 - l2; --i2) {
            if (StringUtilRt.charsEqualIgnoreCase(text.charAt(i2), suffix.charAt(i2 + l2 - l1))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s2, char c2, int start, int end) {
        if (s2 == null) {
            StringUtilRt.$$$reportNull$$$0(29);
        }
        start = Math.max(start, 0);
        for (int i2 = Math.min(end, s2.length()) - 1; i2 >= start; --i2) {
            if (s2.charAt(i2) != c2) continue;
            return i2;
        }
        return -1;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s2) {
        if (StringUtilRt.isEmpty(s2)) {
            return true;
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (s2.charAt(i2) <= ' ') continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s2) {
        return StringUtilRt.notNullize(s2, "");
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s2, @NotNull String defaultValue) {
        if (defaultValue == null) {
            StringUtilRt.$$$reportNull$$$0(30);
        }
        String string = s2 == null ? defaultValue : s2;
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> splitHonorQuotes(@NotNull String s2, char separator) {
        if (s2 == null) {
            StringUtilRt.$$$reportNull$$$0(32);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(s2.length());
        char quote = '\u0000';
        boolean isEscaped = false;
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            boolean isEscape;
            char c2 = s2.charAt(i2);
            boolean isSeparator = c2 == separator;
            boolean isQuote = c2 == '\"' || c2 == '\'';
            boolean isQuoted = quote != '\u0000';
            boolean bl = isEscape = c2 == '\\';
            if (!isQuoted && isSeparator) {
                if (builder.length() <= 0) continue;
                result2.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if (!isEscaped && isQuote && (quote == '\u0000' || quote == c2)) {
                quote = isQuoted ? (char)'\u0000' : c2;
            }
            isEscaped = isEscape && !isEscaped;
            builder.append(c2);
        }
        if (builder.length() > 0) {
            result2.add(builder.toString());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            StringUtilRt.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long fileSize) {
        return StringUtilRt.formatFileSize(fileSize, " ", -1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long fileSize, @NotNull String string) {
        void unitSeparator;
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(34);
        }
        return StringUtilRt.formatFileSize(fileSize, (String)unitSeparator, -1);
    }

    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long fileSize, @NotNull String unitSeparator, int n2) {
        int rank;
        if (unitSeparator == null) {
            StringUtilRt.$$$reportNull$$$0(35);
        }
        if (fileSize < 0L) {
            throw new IllegalArgumentException("Invalid value: " + fileSize);
        }
        if (fileSize == 0L) {
            String string = '0' + unitSeparator + 'B';
            if (string == null) {
                StringUtilRt.$$$reportNull$$$0(36);
            }
            return string;
        }
        if (rank < 0) {
            rank = StringUtilRt.rankForFileSize(fileSize);
        }
        double value2 = (double)fileSize / Math.pow(1000.0, rank);
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB", "PB", "EB"};
        String string = new DecimalFormat("0.##").format(value2) + unitSeparator + units[rank];
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(37);
        }
        return string;
    }

    @Contract(pure=true)
    public static int rankForFileSize(long fileSize) {
        if (fileSize < 0L) {
            throw new IllegalArgumentException("Invalid value: " + fileSize);
        }
        return (int)((Math.log10(fileSize) + 2.1714778384307465E-6) / 3.0);
    }

    @Contract(pure=true)
    public static boolean isQuotedString(@NotNull String s2) {
        int length;
        if (s2 == null) {
            StringUtilRt.$$$reportNull$$$0(38);
        }
        if ((length = s2.length()) <= 1) {
            return false;
        }
        char firstChar = s2.charAt(0);
        if (firstChar != '\'' && firstChar != '\"') {
            return false;
        }
        return firstChar == s2.charAt(length - 1);
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s2) {
        if (s2 == null) {
            StringUtilRt.$$$reportNull$$$0(39);
        }
        String string = StringUtilRt.isQuotedString(s2) ? s2.substring(1, s2.length() - 1) : s2;
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s2, char quotationChar) {
        if (s2 == null) {
            StringUtilRt.$$$reportNull$$$0(41);
        }
        boolean quoted = s2.length() > 1 && quotationChar == s2.charAt(0) && quotationChar == s2.charAt(s2.length() - 1);
        String string = quoted ? s2.substring(1, s2.length() - 1) : s2;
        if (string == null) {
            StringUtilRt.$$$reportNull$$$0(42);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, @NotNull CharSequence prefix) {
        int l2;
        int l1;
        if (text == null) {
            StringUtilRt.$$$reportNull$$$0(43);
        }
        if (prefix == null) {
            StringUtilRt.$$$reportNull$$$0(44);
        }
        if ((l1 = text.length()) < (l2 = prefix.length())) {
            return false;
        }
        for (int i2 = 0; i2 < l2; ++i2) {
            if (text.charAt(i2) == prefix.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtilRt.$$$reportNull$$$0(45);
        }
        return StringUtilRt.stringHashCodeInsensitive(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from2, int to) {
        if (chars == null) {
            StringUtilRt.$$$reportNull$$$0(46);
        }
        return StringUtilRt.stringHashCodeInsensitive(chars, from2, to, 0);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from2, int to, int prefixHash) {
        if (chars == null) {
            StringUtilRt.$$$reportNull$$$0(47);
        }
        int h2 = prefixHash;
        for (int off = from2; off < to; ++off) {
            h2 = 31 * h2 + StringUtilRt.toLowerCase(chars.charAt(off));
        }
        return h2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 31: 
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 31: 
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 42: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 31: 
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/StringUtilRt";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 24: 
            case 26: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 29: 
            case 32: 
            case 38: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSeparator";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/text/StringUtilRt";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyLineSeparators";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 31: 
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 42: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unifyLineSeparators";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseEnum";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "formatFileSize";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 39: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 31: 
            case 33: 
            case 36: 
            case 37: 
            case 40: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

