/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.toml;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleVersionCatalogHandlerKt;
import org.jetbrains.plugins.gradle.service.resolve.VersionCatalogsLocator;
import org.jetbrains.plugins.gradle.toml.TomlHeaderKind;
import org.jetbrains.plugins.gradle.toml.TomlVersionCatalogVisitor;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlKey;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlTable;
import org.toml.lang.psi.ext.TomlKeyKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a#\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0002\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001*\u00020\u0006H\u0000\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006H\u0000\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u0018H\u0002\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u0006H\u0002\"\u000e\u0010\u001b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"getTableEntries", "", "Lorg/toml/lang/psi/TomlKeySegment;", "context", "Lcom/intellij/psi/PsiElement;", "tableName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getVersions", "getLibraries", "getVersionCatalogParts", "findTomlFile", "Lorg/toml/lang/psi/TomlFile;", "name", "findTomlFileDynamically", "Lcom/intellij/openapi/vfs/VirtualFile;", "findOriginInTomlFile", "method", "Lcom/intellij/psi/PsiMethod;", "getTomlParentSectionName", "tomlKeyValue", "Lorg/toml/lang/psi/TomlKeyValue;", "getVersionCatalogName", "psiClass", "Lcom/intellij/psi/PsiClass;", "getTomlHeaderKind", "Lorg/jetbrains/plugins/gradle/toml/TomlHeaderKind;", "TOML_TABLE_VERSIONS", "TOML_TABLE_LIBRARIES", "TOML_TABLE_BUNDLES", "TOML_TABLE_PLUGINS", "METHOD_GET_PLUGINS", "METHOD_GET_VERSIONS", "METHOD_GET_BUNDLES", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\norg/jetbrains/plugins/gradle/toml/UtilKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,167:1\n19#2:168\n19#2:185\n19#2:188\n455#3:169\n455#3:171\n1#4:170\n1#4:182\n1617#5,9:172\n1869#5:181\n1870#5:183\n1626#5:184\n30#6,2:186\n*S KotlinDebug\n*F\n+ 1 util.kt\norg/jetbrains/plugins/gradle/toml/UtilKt\n*L\n28#1:168\n42#1:185\n78#1:188\n29#1:169\n30#1:171\n30#1:182\n30#1:172,9\n30#1:181\n30#1:183\n30#1:184\n49#1:186,2\n*E\n"})
public final class UtilKt {
    @NotNull
    private static final String TOML_TABLE_VERSIONS = "versions";
    @NotNull
    private static final String TOML_TABLE_LIBRARIES = "libraries";
    @NotNull
    private static final String TOML_TABLE_BUNDLES = "bundles";
    @NotNull
    private static final String TOML_TABLE_PLUGINS = "plugins";
    @NotNull
    private static final String METHOD_GET_PLUGINS = "getPlugins";
    @NotNull
    private static final String METHOD_GET_VERSIONS = "getVersions";
    @NotNull
    private static final String METHOD_GET_BUNDLES = "getBundles";

    /*
     * WARNING - void declaration
     */
    private static final List<TomlKeySegment> getTableEntries(PsiElement context, String tableName) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object v4;
        Iterable $i$f$childrenOfType22;
        block5: {
            PsiFile $this$asSafely$iv = context.getContainingFile();
            boolean $i$f$asSafely = false;
            PsiFile psiFile = $this$asSafely$iv;
            if (!(psiFile instanceof TomlFile)) {
                psiFile = null;
            }
            TomlFile tomlFile = (TomlFile)psiFile;
            if (tomlFile == null) {
                return CollectionsKt.emptyList();
            }
            TomlFile file = tomlFile;
            PsiElement $this$childrenOfType$iv = (PsiElement)file;
            boolean $i$f$childrenOfType22 = false;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, TomlTable.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
            $i$f$childrenOfType22 = list;
            for (Object t : $i$f$childrenOfType22) {
                TomlTable it = (TomlTable)t;
                boolean bl = false;
                TomlKey tomlKey = it.getHeader().getKey();
                if (!Intrinsics.areEqual((Object)(tomlKey != null ? TomlKeyKt.getName((TomlKey)tomlKey) : null), (Object)tableName)) continue;
                v4 = t;
                break block5;
            }
            v4 = null;
        }
        TomlTable tomlTable = v4;
        if (tomlTable == null) {
            return CollectionsKt.emptyList();
        }
        TomlTable targetTable = tomlTable;
        Object $this$childrenOfType$iv = (PsiElement)targetTable;
        boolean $i$f$childrenOfType = false;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, TomlKeyValue.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
        $this$childrenOfType$iv = list;
        boolean $i$f$mapNotNull = false;
        $i$f$childrenOfType22 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TomlKeySegment it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TomlKeyValue it = (TomlKeyValue)element$iv$iv;
            boolean bl2 = false;
            if ((TomlKeySegment)CollectionsKt.singleOrNull((List)it.getKey().getSegments()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<TomlKeySegment> getVersions(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return UtilKt.getTableEntries(context, TOML_TABLE_VERSIONS);
    }

    @NotNull
    public static final List<TomlKeySegment> getLibraries(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return UtilKt.getTableEntries(context, TOML_TABLE_LIBRARIES);
    }

    @NotNull
    public static final List<String> getVersionCatalogParts(@NotNull String $this$getVersionCatalogParts) {
        Intrinsics.checkNotNullParameter((Object)$this$getVersionCatalogParts, (String)"<this>");
        String[] stringArray = new String[]{"_", "-"};
        return StringsKt.split$default((CharSequence)$this$getVersionCatalogParts, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }

    @Nullable
    public static final TomlFile findTomlFile(@NotNull PsiElement context, @NotNull String name) {
        TomlFile tomlFile;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        VirtualFile virtualFile = GradleVersionCatalogHandlerKt.getVersionCatalogFiles(module2).get(name);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        PsiFile psiFile = context.getManager().findFile(file);
        if (psiFile != null) {
            PsiFile $this$asSafely$iv = psiFile;
            boolean $i$f$asSafely = false;
            PsiFile psiFile2 = $this$asSafely$iv;
            if (!(psiFile2 instanceof TomlFile)) {
                psiFile2 = null;
            }
            tomlFile = (TomlFile)psiFile2;
        } else {
            tomlFile = null;
        }
        return tomlFile;
    }

    private static final VirtualFile findTomlFileDynamically(PsiElement context, String name) {
        PsiFile psiFile;
        block6: {
            block5: {
                psiFile = context.getContainingFile();
                if (psiFile == null || (psiFile = psiFile.getOriginalFile()) == null || (psiFile = psiFile.getVirtualFile()) == null) break block5;
                PsiFile it = psiFile;
                boolean bl = false;
                Module module = ProjectFileIndex.getInstance((Project)context.getProject()).getModuleForFile((VirtualFile)it);
                psiFile = module;
                if (module != null) break block6;
            }
            return null;
        }
        PsiFile module = psiFile;
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<VersionCatalogsLocator> serviceClass$iv = VersionCatalogsLocator.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Path path = (Path)((VersionCatalogsLocator)object).getVersionCatalogsForModule((Module)module).get(name);
        if (path == null) {
            return null;
        }
        Path tomlPath = path;
        return VfsUtil.findFile((Path)tomlPath, (boolean)false);
    }

    @Nullable
    public static final PsiElement findOriginInTomlFile(@NotNull PsiMethod method, @NotNull PsiElement context) {
        TomlFile tomlFile;
        List containingClasses;
        block5: {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object[] objectArray = new PsiClass[1];
            if (method.getContainingClass() == null) {
                PsiClass cfr_ignored_0 = objectArray[0];
                return null;
            }
            containingClasses = CollectionsKt.mutableListOf((Object[])objectArray);
            while (((PsiClass)CollectionsKt.last((List)containingClasses)).getContainingClass() != null) {
                PsiClass psiClass = ((PsiClass)CollectionsKt.last((List)containingClasses)).getContainingClass();
                Intrinsics.checkNotNull((Object)psiClass);
                containingClasses.add(psiClass);
            }
            CollectionsKt.reverse((List)containingClasses);
            String string = UtilKt.getVersionCatalogName((PsiClass)CollectionsKt.first((List)containingClasses));
            if (string == null) {
                return null;
            }
            String name = string;
            Object[] objectArray2 = new String[]{StringUtil.decapitalize((String)name), name};
            for (String it : (Iterable)CollectionsKt.listOf((Object[])objectArray2)) {
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                TomlFile tomlFile2 = UtilKt.findTomlFile(context, it);
                if (tomlFile2 == null) continue;
                tomlFile = tomlFile2;
                break block5;
            }
            tomlFile = null;
        }
        if (tomlFile == null) {
            return null;
        }
        TomlFile toml = tomlFile;
        TomlVersionCatalogVisitor tomlVisitor = new TomlVersionCatalogVisitor(com.intellij.util.containers.UtilKt.tail((List)containingClasses), method);
        toml.accept((PsiElementVisitor)tomlVisitor);
        return tomlVisitor.getResolveTarget();
    }

    @Nullable
    public static final String getTomlParentSectionName(@NotNull TomlKeyValue tomlKeyValue) {
        PsiElement psiElement;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)tomlKeyValue, (String)"tomlKeyValue");
                psiElement = tomlKeyValue.getParent();
                if (psiElement == null) break block4;
                PsiElement $this$asSafely$iv = psiElement;
                boolean $i$f$asSafely = false;
                PsiElement psiElement2 = $this$asSafely$iv;
                if (!(psiElement2 instanceof TomlTable)) {
                    psiElement2 = null;
                }
                if ((psiElement = (TomlTable)psiElement2) != null) break block5;
            }
            return null;
        }
        PsiElement parentTable = psiElement;
        TomlKey tomlKey = parentTable.getHeader().getKey();
        return tomlKey != null ? TomlKeyKt.getName((TomlKey)tomlKey) : null;
    }

    private static final String getVersionCatalogName(PsiClass psiClass) {
        String string = psiClass.getName();
        if (string == null || (string = StringsKt.substringAfter$default((String)string, (String)"LibrariesFor", null, (int)2, null)) == null) {
            return null;
        }
        String name = string;
        if (StringsKt.endsWith$default((String)name, (String)"InPluginsBlock", (boolean)false, (int)2, null)) {
            return StringsKt.substringBefore$default((String)name, (String)"InPluginsBlock", null, (int)2, null);
        }
        return name;
    }

    private static final TomlHeaderKind getTomlHeaderKind(PsiClass $this$getTomlHeaderKind) {
        String string = $this$getTomlHeaderKind.getName();
        if (string == null) {
            return null;
        }
        String name = string;
        return StringsKt.endsWith$default((String)name, (String)"VersionAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.VERSIONS : (StringsKt.endsWith$default((String)name, (String)"BundleAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.BUNDLES : (StringsKt.endsWith$default((String)name, (String)"PluginAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.PLUGINS : (StringsKt.endsWith$default((String)name, (String)"LibraryAccessors", (boolean)false, (int)2, null) ? TomlHeaderKind.LIBRARIES : null)));
    }

    private static final TomlHeaderKind getTomlHeaderKind(String $this$getTomlHeaderKind) {
        return switch ($this$getTomlHeaderKind) {
            case TOML_TABLE_VERSIONS -> TomlHeaderKind.VERSIONS;
            case TOML_TABLE_LIBRARIES -> TomlHeaderKind.LIBRARIES;
            case TOML_TABLE_BUNDLES -> TomlHeaderKind.BUNDLES;
            case TOML_TABLE_PLUGINS -> TomlHeaderKind.PLUGINS;
            default -> null;
        };
    }

    public static final /* synthetic */ TomlHeaderKind access$getTomlHeaderKind(String $receiver) {
        return UtilKt.getTomlHeaderKind($receiver);
    }

    public static final /* synthetic */ TomlHeaderKind access$getTomlHeaderKind(PsiClass $receiver) {
        return UtilKt.getTomlHeaderKind($receiver);
    }
}

