/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandHandlerDescriptor;
import org.jkiss.dbeaver.model.sql.registry.SQLPragmaHandlerDescriptor;

public class SQLCommandsRegistry {
    static final String TAG_COMMAND = "command";
    static final String TAG_PRAGMA = "pragma";
    private static SQLCommandsRegistry instance = null;
    private final Map<String, SQLCommandHandlerDescriptor> commandHandlers = new HashMap<String, SQLCommandHandlerDescriptor>();
    private final Map<String, SQLPragmaHandlerDescriptor> pragmaHandlers = new HashMap<String, SQLPragmaHandlerDescriptor>();

    public static synchronized SQLCommandsRegistry getInstance() {
        if (instance == null) {
            instance = new SQLCommandsRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SQLCommandsRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        IConfigurationElement[] iConfigurationElementArray = extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.sqlCommand");
        int n = extConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            SQLCommandHandlerDescriptor commandDescriptor;
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_COMMAND.equals(ext.getName()) && (commandDescriptor = new SQLCommandHandlerDescriptor(ext)).isEnabled()) {
                this.commandHandlers.put(commandDescriptor.getId(), commandDescriptor);
            }
            if (TAG_PRAGMA.equals(ext.getName())) {
                SQLPragmaHandlerDescriptor descriptor = new SQLPragmaHandlerDescriptor(ext);
                this.pragmaHandlers.put(descriptor.getId(), descriptor);
            }
            ++n2;
        }
    }

    public void dispose() {
        this.commandHandlers.clear();
    }

    public List<SQLCommandHandlerDescriptor> getCommandHandlers() {
        return new ArrayList<SQLCommandHandlerDescriptor>(this.commandHandlers.values());
    }

    public SQLCommandHandlerDescriptor getCommandHandler(String id) {
        return this.commandHandlers.get(id);
    }

    @Nullable
    public SQLPragmaHandlerDescriptor getPragmaHandler(@NotNull String id) {
        return this.pragmaHandlers.get(id);
    }
}

