/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIAssistant;
import org.jkiss.dbeaver.model.ai.impl.AIAssistantImpl;
import org.jkiss.dbeaver.model.ai.registry.AIAssistantDescriptor;
import org.jkiss.dbeaver.model.app.DBPWorkspace;

public class AIAssistantRegistry {
    private static AIAssistantRegistry instance = null;
    private AIAssistantDescriptor globalDescriptor;

    public static synchronized AIAssistantRegistry getInstance() {
        if (instance == null) {
            instance = new AIAssistantRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    public AIAssistantRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("com.dbeaver.ai.assistant");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("assistant".equals(ext.getName())) {
                AIAssistantDescriptor descriptor = new AIAssistantDescriptor(ext);
                if (this.globalDescriptor == null || descriptor.getPriority() > this.globalDescriptor.getPriority()) {
                    this.globalDescriptor = descriptor;
                }
            }
            ++n2;
        }
    }

    public AIAssistantDescriptor getDescriptor() {
        return this.globalDescriptor;
    }

    @NotNull
    public <T extends AIAssistant> T createAssistant(@NotNull DBPWorkspace workspace) throws IllegalStateException {
        if (this.globalDescriptor != null) {
            try {
                return (T)this.globalDescriptor.createInstance(workspace);
            }
            catch (DBException e) {
                throw new IllegalStateException(e);
            }
        }
        return (T)new AIAssistantImpl(workspace);
    }
}

