/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfHeader;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfText;

public final class RtfStyleSheetTable {
    private static int startIndex = 15;
    public static final int STATUS_OK = 0;
    public static final int STATUS_DEFAULT = 1;
    private static final String STANDARD_STYLE = "Standard";
    private static RtfStyleSheetTable instance = new RtfStyleSheetTable();
    private Hashtable styles = new Hashtable();
    private Hashtable attrTable = new Hashtable();
    private Vector nameTable = new Vector();
    private String defaultStyleName = "Standard";

    private RtfStyleSheetTable() {
    }

    public static RtfStyleSheetTable getInstance() {
        return instance;
    }

    public void setDefaultStyle(String styleName) {
        this.defaultStyleName = styleName;
    }

    public String getDefaultStyleName() {
        if (this.attrTable.get(this.defaultStyleName) != null) {
            return this.defaultStyleName;
        }
        if (this.attrTable.get(STANDARD_STYLE) != null) {
            this.defaultStyleName = STANDARD_STYLE;
            return this.defaultStyleName;
        }
        return null;
    }

    public void addStyle(String name, RtfAttributes attrs) {
        this.nameTable.addElement(name);
        if (attrs != null) {
            this.attrTable.put(name, attrs);
        }
        this.styles.put(name, this.nameTable.size() - 1 + startIndex);
    }

    public int addStyleToAttributes(String name, RtfAttributes attr) {
        int status = 0;
        Integer style = (Integer)this.styles.get(name);
        if (style == null && !name.equals(this.defaultStyleName)) {
            name = this.defaultStyleName;
            style = (Integer)this.styles.get(name);
            status = 1;
        }
        if (style == null) {
            return status;
        }
        attr.set("cs", style);
        Object o = this.attrTable.get(name);
        if (o != null) {
            RtfAttributes rtfAttr = (RtfAttributes)o;
            Iterator names = rtfAttr.nameIterator();
            while (names.hasNext()) {
                String attrName = (String)names.next();
                if (attr.isSet(attrName)) continue;
                Integer i = (Integer)rtfAttr.getValue(attrName);
                if (i == null) {
                    attr.set(attrName);
                    continue;
                }
                attr.set(attrName, i);
            }
        }
        return status;
    }

    public void writeStyleSheet(RtfHeader header) throws IOException {
        if (this.styles == null || this.styles.size() == 0) {
            return;
        }
        header.writeGroupMark(true);
        header.writeControlWord("stylesheet");
        int number = this.nameTable.size();
        for (int i = 0; i < number; ++i) {
            String name = (String)this.nameTable.elementAt(i);
            header.writeGroupMark(true);
            header.writeControlWord("*\\" + this.getRtfStyleReference(name));
            Object o = this.attrTable.get(name);
            if (o != null) {
                header.writeAttributes((RtfAttributes)o, RtfText.ATTR_NAMES);
                header.writeAttributes((RtfAttributes)o, RtfText.ALIGNMENT);
            }
            header.write(name + ";");
            header.writeGroupMark(false);
        }
        header.writeGroupMark(false);
    }

    private String getRtfStyleReference(String name) {
        return "cs" + this.styles.get(name).toString();
    }
}

