/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.WindowTabState;
import net.infonode.docking.internalutil.ButtonInfo;
import net.infonode.docking.internalutil.CloseButtonInfo;
import net.infonode.docking.internalutil.DockButtonInfo;
import net.infonode.docking.internalutil.InternalDockingUtil;
import net.infonode.docking.internalutil.MinimizeButtonInfo;
import net.infonode.docking.internalutil.RestoreButtonInfo;
import net.infonode.docking.internalutil.UndockButtonInfo;
import net.infonode.docking.properties.WindowTabProperties;
import net.infonode.docking.properties.WindowTabStateProperties;
import net.infonode.gui.ContainerList;
import net.infonode.gui.panel.DirectionPanel;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapListener;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.tabbedpanel.titledtab.TitledTab;
import net.infonode.tabbedpanel.titledtab.TitledTabStateProperties;
import net.infonode.util.Direction;

class WindowTab
extends TitledTab {
    private static final TitledTabStateProperties EMPTY_PROPERTIES = new TitledTabStateProperties();
    private static final WindowTabProperties EMPTY_TAB_PROPERTIES = new WindowTabProperties();
    private static final ButtonInfo[] buttonInfos = new ButtonInfo[]{new UndockButtonInfo(WindowTabStateProperties.UNDOCK_BUTTON_PROPERTIES), new DockButtonInfo(WindowTabStateProperties.DOCK_BUTTON_PROPERTIES), new MinimizeButtonInfo(WindowTabStateProperties.MINIMIZE_BUTTON_PROPERTIES), new RestoreButtonInfo(WindowTabStateProperties.RESTORE_BUTTON_PROPERTIES), new CloseButtonInfo(WindowTabStateProperties.CLOSE_BUTTON_PROPERTIES)};
    private final DockingWindow window;
    private final AbstractButton[][] buttons = new AbstractButton[WindowTabState.getStateCount()][];
    private final DirectionPanel[] buttonBoxes = new DirectionPanel[WindowTabState.getStateCount()];
    private final DirectionPanel customComponents = new DirectionPanel();
    private final DirectionPanel highlightedFocusedPanel = new DirectionPanel(){

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }
    };
    private final WindowTabProperties windowTabProperties = new WindowTabProperties(EMPTY_TAB_PROPERTIES);
    private ContainerList tabComponentsList;
    private boolean isFocused;
    private final PropertyMapListener windowPropertiesListener = new PropertyMapListener(){

        @Override
        public void propertyValuesChanged(PropertyMap propertyObject, Map changes) {
            WindowTab.this.updateTabButtons(null);
        }
    };
    private final PropertyMapTreeListener windowTabPropertiesListener = new PropertyMapTreeListener(){

        @Override
        public void propertyValuesChanged(Map changes) {
            WindowTab.this.updateTabButtons(changes);
        }
    };

    WindowTab(DockingWindow window, boolean emptyContent) {
        super(window.getTitle(), window.getIcon(), emptyContent ? null : new SimplePanel(window), null);
        this.window = window;
        int i = 0;
        while (i < WindowTabState.getStateCount()) {
            this.buttonBoxes[i] = new DirectionPanel(){

                @Override
                public Dimension getMinimumSize() {
                    return new Dimension(0, 0);
                }
            };
            this.buttons[i] = new AbstractButton[buttonInfos.length];
            ++i;
        }
        this.highlightedFocusedPanel.add(this.customComponents);
        this.highlightedFocusedPanel.add(this.buttonBoxes[WindowTabState.HIGHLIGHTED.getValue()]);
        this.setHighlightedStateTitleComponent(this.highlightedFocusedPanel);
        this.setNormalStateTitleComponent(this.buttonBoxes[WindowTabState.NORMAL.getValue()]);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                WindowTab.this.getWindow().fireTabWindowMouseButtonEvent(e);
                this.checkPopupMenu(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                WindowTab.this.getWindow().fireTabWindowMouseButtonEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                WindowTab.this.getWindow().fireTabWindowMouseButtonEvent(e);
                this.checkPopupMenu(e);
            }

            private void checkPopupMenu(MouseEvent e) {
                if (e.isPopupTrigger() && WindowTab.this.contains(e.getPoint())) {
                    WindowTab.this.window.showPopupMenu(e);
                }
            }
        });
        this.getProperties().addSuperObject(this.windowTabProperties.getTitledTabProperties());
        PropertyMapWeakListenerManager.addWeakTreeListener(this.windowTabProperties.getMap(), this.windowTabPropertiesListener);
        PropertyMapWeakListenerManager.addWeakListener(this.window.getWindowProperties().getMap(), this.windowPropertiesListener);
        this.windowTabProperties.getTitledTabProperties().getHighlightedProperties().addSuperObject(EMPTY_PROPERTIES);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.buttonBoxes != null) {
            int i = 0;
            while (i < WindowTabState.getStateCount()) {
                if (this.buttonBoxes[i] != null) {
                    SwingUtilities.updateComponentTreeUI(this.buttonBoxes[i]);
                }
                ++i;
            }
        }
    }

    void setFocused(boolean focused) {
        if (this.isFocused != focused) {
            this.isFocused = focused;
            TitledTabStateProperties properties = focused ? this.windowTabProperties.getFocusedProperties() : EMPTY_PROPERTIES;
            this.windowTabProperties.getTitledTabProperties().getHighlightedProperties().getMap().replaceSuperMap(this.windowTabProperties.getTitledTabProperties().getHighlightedProperties().getMap().getSuperMap(), properties.getMap());
            this.highlightedFocusedPanel.remove(1);
            this.highlightedFocusedPanel.add(this.buttonBoxes[focused ? WindowTabState.FOCUSED.getValue() : WindowTabState.HIGHLIGHTED.getValue()]);
            this.highlightedFocusedPanel.revalidate();
        }
    }

    void setProperties(WindowTabProperties properties) {
        this.windowTabProperties.getMap().replaceSuperMap(this.windowTabProperties.getMap().getSuperMap(), properties.getMap());
    }

    void unsetProperties() {
        this.setProperties(EMPTY_TAB_PROPERTIES);
    }

    void updateTabButtons(Map changes) {
        WindowTabState[] states = WindowTabState.getStates();
        int i = 0;
        while (i < states.length) {
            WindowTabState state = states[i];
            WindowTabStateProperties buttonProperties = state == WindowTabState.FOCUSED ? this.windowTabProperties.getFocusedButtonProperties() : (state == WindowTabState.HIGHLIGHTED ? this.windowTabProperties.getHighlightedButtonProperties() : this.windowTabProperties.getNormalButtonProperties());
            InternalDockingUtil.updateButtons(buttonInfos, this.buttons[i], this.buttonBoxes[i], this.window, buttonProperties.getMap(), changes);
            this.buttonBoxes[i].setDirection((state == WindowTabState.NORMAL ? this.getProperties().getNormalProperties() : this.getProperties().getHighlightedProperties()).getDirection());
            ++i;
        }
        Direction dir = this.getProperties().getHighlightedProperties().getDirection();
        this.highlightedFocusedPanel.setDirection(dir);
        this.customComponents.setDirection(dir);
    }

    DockingWindow getWindow() {
        return this.window;
    }

    void windowTitleChanged() {
        this.setText(this.getWindow().getTitle());
        this.setIcon(this.getWindow().getIcon());
    }

    @Override
    public String toString() {
        return this.window != null ? this.window.toString() : null;
    }

    void setContentComponent(Component component) {
        ((SimplePanel)this.getContentComponent()).setComponent(component);
    }

    List getCustomTabComponentsList() {
        if (this.tabComponentsList == null) {
            this.tabComponentsList = new ContainerList(this.customComponents);
        }
        return this.tabComponentsList;
    }
}

