/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel;

import javax.swing.JComponent;
import javax.swing.JPanel;
import net.infonode.gui.layout.StackableLayout;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabListener;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanel;

public class TabContentPanel
extends JPanel {
    private TabbedPanel tabbedPanel;
    private StackableLayout layout = new StackableLayout(this);
    private TabListener listener = new TabAdapter(){

        @Override
        public void tabSelected(TabStateChangedEvent event) {
            TabContentPanel.this.layout.showComponent(event.getTab() == null ? null : event.getTab().getContentComponent());
        }

        @Override
        public void tabRemoved(TabRemovedEvent event) {
            if (event.getTab().getContentComponent() != null) {
                TabContentPanel.this.remove(event.getTab().getContentComponent());
            }
        }

        @Override
        public void tabAdded(TabEvent event) {
            if (event.getTab().getContentComponent() != null) {
                TabContentPanel.this.add(event.getTab().getContentComponent());
            }
        }
    };

    public TabContentPanel() {
        this.setLayout(this.layout);
        this.setOpaque(false);
        this.layout.setAutoShowFirstComponent(false);
    }

    public TabContentPanel(TabbedPanel tabbedPanel) {
        this();
        this.setTabbedPanel(tabbedPanel);
    }

    public TabbedPanel getTabbedPanel() {
        return this.tabbedPanel;
    }

    public void setTabbedPanel(TabbedPanel tabbedPanel) {
        if (this.tabbedPanel != tabbedPanel) {
            if (this.tabbedPanel != null) {
                this.tabbedPanel.removeTabListener(this.listener);
                this.removeAll();
            }
            this.tabbedPanel = tabbedPanel;
            if (this.tabbedPanel != null) {
                tabbedPanel.addTabListener(this.listener);
                int i = 0;
                while (i < tabbedPanel.getTabCount()) {
                    JComponent c = tabbedPanel.getTabAt(i).getContentComponent();
                    if (c != null) {
                        this.add(tabbedPanel.getTabAt(i).getContentComponent());
                    }
                    ++i;
                }
            }
        }
    }
}

