/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.aws.s3;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.google.common.base.Optional;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class S3RegionalResource {
    private static final Pattern REGIONAL_ENDPOINT_PATTERN = Pattern.compile("^s3:\\/\\/(.+)?\\.s3[.-]([a-z0-9-]+)\\.amazonaws\\.com(\\.[a-z]+)?\\/(.+)");
    private static final Pattern FALLBACK_ENDPOINT_PATTERN = Pattern.compile("^[a-z0-9]+:\\/\\/([^\\/]+)\\/(.+)");
    private final URI uri;
    private Optional<Region> region;
    private String bucketName;
    private String key;

    public S3RegionalResource(URI uri) {
        this.uri = uri;
        this.configure();
    }

    public Optional<Region> getRegion() {
        return this.region;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getKey() {
        return this.key;
    }

    private void configure() {
        Matcher matcher = REGIONAL_ENDPOINT_PATTERN.matcher(this.uri.toString());
        if (matcher.find()) {
            String bucketName = matcher.group(1);
            String region = matcher.group(2);
            String key = matcher.group(4);
            Region derivedRegion = region.equals("external-1") ? Region.getRegion((Regions)Regions.US_EAST_1) : RegionUtils.getRegion((String)region);
            this.region = Optional.of((Object)derivedRegion);
            this.bucketName = bucketName;
            this.key = key;
            return;
        }
        matcher = FALLBACK_ENDPOINT_PATTERN.matcher(this.uri.toString());
        if (matcher.find()) {
            this.region = Optional.absent();
            this.bucketName = this.getBucketName(matcher.group(1));
            this.key = matcher.group(2);
            return;
        }
        throw new RuntimeException(String.format("Can't parse S3 URI '%s'", this.uri));
    }

    private String getBucketName(String bucket) {
        return bucket.replaceAll("\\.s3\\.amazonaws\\.com", "").replaceAll("\\.s3-external-1\\.amazonaws\\.com", "");
    }
}

