/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ResultClassInReturnTypeCheckerKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\tH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ResultClassInReturnTypeChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isForbiddenReturnType", "", "returnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "declarationDescriptor", "frontend"})
public final class ResultClassInReturnTypeChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        LanguageVersionSettings languageVersionSettings = context.getLanguageVersionSettings();
        if (languageVersionSettings.supportsFeature(LanguageFeature.AllowNullOperatorsForResultAndResultReturnTypeByDefault)) {
            return;
        }
        if (!(declaration instanceof KtCallableDeclaration) || !(descriptor instanceof CallableMemberDescriptor)) {
            return;
        }
        KotlinType kotlinType = ((CallableMemberDescriptor)descriptor).getReturnType();
        if (kotlinType == null) {
            return;
        }
        KotlinType returnType = kotlinType;
        if (this.isForbiddenReturnType(returnType, declaration, descriptor)) {
            PsiElement psiElement;
            KtTypeReference ktTypeReference = ((KtCallableDeclaration)declaration).getTypeReference();
            if (ktTypeReference != null) {
                psiElement = ktTypeReference;
            } else {
                psiElement = ((KtCallableDeclaration)declaration).getNameIdentifier();
                if (psiElement == null) {
                    return;
                }
            }
            PsiElement typeReferenceOrDeclarationName = psiElement;
            BindingTrace bindingTrace = context.getTrace();
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.RESULT_CLASS_IN_RETURN_TYPE.on(typeReferenceOrDeclarationName);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, "on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
        }
    }

    private final boolean isForbiddenReturnType(KotlinType returnType, KtDeclaration declaration, DeclarationDescriptor declarationDescriptor) {
        if (!ResultClassInReturnTypeCheckerKt.isResultType(returnType)) {
            return false;
        }
        if (declarationDescriptor instanceof PropertyDescriptor || declarationDescriptor instanceof PropertyGetterDescriptor) {
            if (declaration instanceof KtProperty) {
                KtPropertyAccessor ktPropertyAccessor = ((KtProperty)declaration).getGetter();
                boolean bl = ktPropertyAccessor != null ? ktPropertyAccessor.hasBody() : false;
                if (bl) {
                    return true;
                }
            }
            DescriptorVisibility descriptorVisibility = ((DeclarationDescriptorWithVisibility)declarationDescriptor).getVisibility();
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "getVisibility(...)");
            DescriptorVisibility visibility = descriptorVisibility;
            return !DescriptorVisibilities.isPrivate(visibility) && !Intrinsics.areEqual(visibility, DescriptorVisibilities.LOCAL);
        }
        return true;
    }
}

