/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverterKt;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u001c\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J(\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0014H\u0016J\"\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J*\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u0018\u0010 \u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u001fH\u0002J0\u0010\"\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/ReflectionCallMethodVisitor;", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "methodVisitor", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;Lorg/jetbrains/org/objectweb/asm/MethodVisitor;)V", "boxValue", "", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "boxedType", "unboxValue", "pushClassLiteral", "resolvedClass", "Lcom/intellij/psi/PsiClass;", "findClass", "internalName", "", "fetchReflectionField", "owner", "name", "visitFieldInsn", "opcode", "", "descriptor", "findMethod", "Lcom/intellij/psi/PsiMethod;", "resolveApplicableMethodCall", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/ReflectionCallMethodVisitor$ResolvedMethodCall;", "fetchReflectionMethod", "resolvedCall", "visitMethodInsn", "isInterface", "", "ResolvedMethodCall", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nReflectionCallClassPatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectionCallClassPatcher.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/ReflectionCallMethodVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n1#2:339\n*E\n"})
final class ReflectionCallMethodVisitor
extends MethodVisitor {
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope scope;

    public ReflectionCallMethodVisitor(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull MethodVisitor methodVisitor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)methodVisitor, (String)"methodVisitor");
        super(589824, methodVisitor);
        this.project = project;
        this.scope = scope;
    }

    private final void boxValue(Type type2, Type boxedType) {
        String methodDescriptor = "(" + type2.getDescriptor() + ")" + boxedType.getDescriptor();
        super.visitMethodInsn(184, boxedType.getInternalName(), "valueOf", methodDescriptor, false);
    }

    private final void unboxValue(Type type2, Type boxedType) {
        String boxedClassName = boxedType.getInternalName();
        String string = EvaluatorValueConverter.Companion.getUNBOXING_METHOD_NAMES().get(boxedClassName);
        if (string == null) {
            throw new IllegalStateException(("Unexpected boxed type: " + boxedType).toString());
        }
        String methodName = string;
        String methodDescriptor = "()" + type2.getDescriptor();
        super.visitMethodInsn(182, boxedClassName, methodName, methodDescriptor, false);
    }

    private final void pushClassLiteral(Type type2, PsiClass resolvedClass) {
        PsiClass psiClass;
        if (type2.getSort() != 10 && type2.getSort() != 9) {
            throw new IllegalStateException("Object or array type expected, got " + type2);
        }
        String internalName = type2.getInternalName();
        PsiClass psiClass2 = resolvedClass;
        if (psiClass2 == null) {
            Intrinsics.checkNotNull((Object)internalName);
            psiClass2 = this.findClass(internalName);
        }
        if ((psiClass = psiClass2) != null && !psiClass.hasModifierProperty("public")) {
            Intrinsics.checkNotNull((Object)internalName);
            super.visitLdcInsn((Object)JvmNameUtilsKt.internalNameToFqn(internalName));
            super.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", false);
        } else {
            super.visitLdcInsn((Object)type2);
        }
    }

    static /* synthetic */ void pushClassLiteral$default(ReflectionCallMethodVisitor reflectionCallMethodVisitor, Type type2, PsiClass psiClass, int n, Object object) {
        if ((n & 2) != 0) {
            psiClass = null;
        }
        reflectionCallMethodVisitor.pushClassLiteral(type2, psiClass);
    }

    private final PsiClass findClass(String internalName) {
        Type type2 = Type.getObjectType((String)internalName);
        if (type2.getSort() != 10) {
            return null;
        }
        SignatureParsing.CharIterator iterator2 = new SignatureParsing.CharIterator(type2.getDescriptor());
        String classType = SignatureParsing.parseTypeStringToTypeInfo((SignatureParsing.CharIterator)iterator2, (SignatureParsing.TypeInfoProvider)StubBuildingVisitor.GUESSING_PROVIDER).text();
        return JavaPsiFacade.getInstance((Project)this.project).findClass(classType, this.scope);
    }

    private final void fetchReflectionField(String owner, String name2) {
        Type type2 = Type.getObjectType((String)owner);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getObjectType(...)");
        ReflectionCallMethodVisitor.pushClassLiteral$default(this, type2, null, 2, null);
        super.visitLdcInsn((Object)name2);
        String methodSignature = "(Ljava/lang/String;)Ljava/lang/reflect/Field;";
        super.visitMethodInsn(182, "java/lang/Class", "getDeclaredField", methodSignature, false);
        super.visitInsn(89);
        super.visitLdcInsn((Object)1);
        super.visitMethodInsn(182, "java/lang/reflect/Field", "setAccessible", "(Z)V", false);
    }

    public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name2, @NotNull String descriptor2) {
        boolean isPut;
        PsiField field2;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiClass psiClass = this.findClass(owner);
        PsiField psiField2 = field2 = psiClass != null ? psiClass.findFieldByName(name2, false) : null;
        if (field2 == null || field2.hasModifierProperty("public")) {
            super.visitFieldInsn(opcode, owner, name2, descriptor2);
            return;
        }
        Type valueType = Type.getType((String)descriptor2);
        Intrinsics.checkNotNull((Object)valueType);
        Type boxedValueType = EvaluatorValueConverterKt.box(valueType);
        this.fetchReflectionField(owner, name2);
        boolean isCategory2Type = valueType.getSize() == 2;
        switch (opcode) {
            case 178: {
                super.visitInsn(1);
                break;
            }
            case 179: {
                super.visitInsn(1);
                super.visitInsn(isCategory2Type ? 94 : 93);
                super.visitInsn(88);
                break;
            }
            case 180: {
                super.visitInsn(95);
                break;
            }
            case 181: {
                super.visitInsn(isCategory2Type ? 91 : 90);
                super.visitInsn(87);
                super.visitInsn(isCategory2Type ? 94 : 91);
                super.visitInsn(isCategory2Type ? 88 : 87);
                super.visitInsn(95);
                super.visitInsn(isCategory2Type ? 94 : 93);
                super.visitInsn(88);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected opcode " + opcode);
            }
        }
        boolean bl = isPut = opcode == 179 || opcode == 181;
        if (isPut && !Intrinsics.areEqual((Object)valueType, (Object)boxedValueType)) {
            this.boxValue(valueType, boxedValueType);
        }
        String methodName = isPut ? "set" : "get";
        String methodSignature = isPut ? "(Ljava/lang/Object;Ljava/lang/Object;)V" : "(Ljava/lang/Object;)Ljava/lang/Object;";
        super.visitMethodInsn(182, "java/lang/reflect/Field", methodName, methodSignature, false);
        if (!isPut) {
            super.visitTypeInsn(192, boxedValueType.getInternalName());
            if (!Intrinsics.areEqual((Object)valueType, (Object)boxedValueType)) {
                this.unboxValue(valueType, boxedValueType);
            }
        }
    }

    private final PsiMethod findMethod(String owner, String name2, String descriptor2) {
        PsiClass psiClass = this.findClass(owner);
        if (psiClass == null) {
            return null;
        }
        PsiClass declaringClass = psiClass;
        PsiMethod[] psiMethodArray = Intrinsics.areEqual((Object)name2, (Object)"<init>") ? declaringClass.getConstructors() : declaringClass.findMethodsByName(name2, true);
        Intrinsics.checkNotNull((Object)psiMethodArray);
        for (PsiMethod method : psiMethodArray) {
            String methodDescriptor = ClassUtil.getAsmMethodSignature((PsiMethod)method);
            if (!Intrinsics.areEqual((Object)methodDescriptor, (Object)descriptor2)) continue;
            return method;
        }
        return null;
    }

    private final ResolvedMethodCall resolveApplicableMethodCall(int opcode, String owner, String name2, String descriptor2) {
        String string;
        PsiClass declaringClass;
        PsiMethod method;
        if (opcode != 182 && opcode != 184 && opcode != 183) {
            return null;
        }
        if (StringsKt.startsWith$default((String)name2, (String)"<", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)name2, (Object)"<init>")) {
            return null;
        }
        if (Intrinsics.areEqual((Object)name2, (Object)"<init>")) {
            return null;
        }
        PsiMethod psiMethod = method = this.findMethod(owner, name2, descriptor2);
        Object object = declaringClass = psiMethod != null ? psiMethod.getContainingClass() : null;
        if (method == null || method.hasModifierProperty("public") || declaringClass == null) {
            return null;
        }
        PsiClassType psiClassType = PsiElementFactory.getInstance((Project)this.project).createType(declaringClass);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"createType(...)");
        PsiClassType declaringClassType = psiClassType;
        String it = string = ClassUtil.getBinaryPresentation((PsiType)((PsiType)declaringClassType));
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        String string2 = ((CharSequence)it).length() > 0 ? string : null;
        if (string2 == null) {
            return null;
        }
        String declaringClassTypeDescriptor = string2;
        Type declaringClassAsmType = Type.getType((String)declaringClassTypeDescriptor);
        int parameterCount = method.getParameterList().getParametersCount();
        ArrayList parameterTypes = new ArrayList(parameterCount);
        ArrayList boxedParameterTypes = new ArrayList(parameterCount);
        for (int index2 = 0; index2 < parameterCount; ++index2) {
            String parameterTypeDescriptor;
            PsiParameter parameter;
            String string3;
            if (method.getParameterList().getParameter(index2) == null) {
                return null;
            }
            String it2 = string3 = ClassUtil.getBinaryPresentation((PsiType)parameter.getType());
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it2);
            if ((((CharSequence)it2).length() > 0 ? string3 : null) == null) {
                return null;
            }
            parameterTypeDescriptor = parameterTypeDescriptor;
            Type parameterType = Type.getType((String)parameterTypeDescriptor);
            ((Collection)parameterTypes).add(parameterType);
            Collection collection = boxedParameterTypes;
            Intrinsics.checkNotNull((Object)parameterType);
            collection.add(EvaluatorValueConverterKt.box(parameterType));
        }
        Intrinsics.checkNotNull((Object)declaringClassAsmType);
        return new ResolvedMethodCall(declaringClass, declaringClassAsmType, parameterTypes, boxedParameterTypes);
    }

    private final void fetchReflectionMethod(String name2, ResolvedMethodCall resolvedCall) {
        boolean isConstructor = Intrinsics.areEqual((Object)name2, (Object)"<init>");
        this.pushClassLiteral(resolvedCall.getDeclaringClassType(), resolvedCall.getDeclaringClass());
        if (!isConstructor) {
            super.visitLdcInsn((Object)name2);
        }
        ReflectionCallMethodVisitor $this$fetchReflectionMethod_u24lambda_u242 = this;
        boolean bl = false;
        super.visitLdcInsn((Object)resolvedCall.getParameterTypes().size());
        super.visitTypeInsn(189, "java/lang/Class");
        int n = resolvedCall.getParameterTypes().size();
        for (int index2 = 0; index2 < n; ++index2) {
            Type parameterType = resolvedCall.getParameterTypes().get(index2);
            Type boxedParameterType = resolvedCall.getBoxedParameterTypes().get(index2);
            super.visitInsn(89);
            super.visitLdcInsn((Object)index2);
            if (!Intrinsics.areEqual((Object)parameterType, (Object)boxedParameterType)) {
                super.visitFieldInsn(178, boxedParameterType.getInternalName(), "TYPE", "Ljava/lang/Class;");
            } else {
                ReflectionCallMethodVisitor.pushClassLiteral$default($this$fetchReflectionMethod_u24lambda_u242, parameterType, null, 2, null);
            }
            super.visitInsn(83);
        }
        String getMethodName = isConstructor ? "getDeclaredConstructor" : "getDeclaredMethod";
        String getMethodSignature2 = isConstructor ? "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;" : "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;";
        super.visitMethodInsn(182, "java/lang/Class", getMethodName, getMethodSignature2, false);
        super.visitInsn(89);
        super.visitLdcInsn((Object)1);
        super.visitMethodInsn(182, "java/lang/reflect/AccessibleObject", "setAccessible", "(Z)V", false);
    }

    public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name2, @NotNull String descriptor2, boolean isInterface) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        ResolvedMethodCall resolvedCall = this.resolveApplicableMethodCall(opcode, owner, name2, descriptor2);
        if (resolvedCall == null) {
            super.visitMethodInsn(opcode, owner, name2, descriptor2, isInterface);
            return;
        }
        boolean isConstructor = Intrinsics.areEqual((Object)name2, (Object)"<init>");
        boolean isStatic = opcode == 184;
        int parameterCount = resolvedCall.getParameterTypes().size();
        super.visitLdcInsn((Object)parameterCount);
        super.visitTypeInsn(189, "java/lang/Object");
        ReflectionCallMethodVisitor $this$visitMethodInsn_u24lambda_u243 = this;
        boolean bl = false;
        for (int index2 = parameterCount - 1; -1 < index2; --index2) {
            Type parameterType = resolvedCall.getParameterTypes().get(index2);
            Type boxedParameterType = resolvedCall.getBoxedParameterTypes().get(index2);
            super.visitInsn(89);
            super.visitInsn(parameterType.getSize() == 2 ? 94 : 93);
            super.visitInsn(88);
            if (!Intrinsics.areEqual((Object)parameterType, (Object)boxedParameterType)) {
                $this$visitMethodInsn_u24lambda_u243.boxValue(parameterType, boxedParameterType);
            }
            super.visitLdcInsn((Object)index2);
            super.visitInsn(95);
            super.visitInsn(83);
        }
        if (isStatic) {
            super.visitInsn(1);
            super.visitInsn(95);
        }
        this.fetchReflectionMethod(name2, resolvedCall);
        if (isConstructor) {
            super.visitInsn(95);
        } else {
            super.visitInsn(91);
            super.visitInsn(87);
        }
        String invokeReceiverType = isConstructor ? "java/lang/reflect/Constructor" : "java/lang/reflect/Method";
        String invokeMethodName = isConstructor ? "newInstance" : "invoke";
        String invokeMethodSignature = isConstructor ? "([Ljava/lang/Object;)Ljava/lang/Object;" : "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;";
        super.visitMethodInsn(182, invokeReceiverType, invokeMethodName, invokeMethodSignature, false);
        Type returnType = isConstructor ? resolvedCall.getDeclaringClassType() : Type.getMethodType((String)descriptor2).getReturnType();
        Intrinsics.checkNotNull((Object)returnType);
        Type boxedReturnType = EvaluatorValueConverterKt.box(returnType);
        super.visitTypeInsn(192, boxedReturnType.getInternalName());
        if (!Intrinsics.areEqual((Object)returnType, (Object)boxedReturnType)) {
            this.unboxValue(returnType, boxedReturnType);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/ReflectionCallMethodVisitor$ResolvedMethodCall;", "", "declaringClass", "Lcom/intellij/psi/PsiClass;", "declaringClassType", "Lorg/jetbrains/org/objectweb/asm/Type;", "parameterTypes", "", "boxedParameterTypes", "<init>", "(Lcom/intellij/psi/PsiClass;Lorg/jetbrains/org/objectweb/asm/Type;Ljava/util/List;Ljava/util/List;)V", "getDeclaringClass", "()Lcom/intellij/psi/PsiClass;", "getDeclaringClassType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "getParameterTypes", "()Ljava/util/List;", "getBoxedParameterTypes", "kotlin.jvm-debugger.evaluation"})
    private static final class ResolvedMethodCall {
        @NotNull
        private final PsiClass declaringClass;
        @NotNull
        private final Type declaringClassType;
        @NotNull
        private final List<Type> parameterTypes;
        @NotNull
        private final List<Type> boxedParameterTypes;

        public ResolvedMethodCall(@NotNull PsiClass declaringClass, @NotNull Type declaringClassType, @NotNull List<Type> parameterTypes, @NotNull List<Type> boxedParameterTypes) {
            Intrinsics.checkNotNullParameter((Object)declaringClass, (String)"declaringClass");
            Intrinsics.checkNotNullParameter((Object)declaringClassType, (String)"declaringClassType");
            Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
            Intrinsics.checkNotNullParameter(boxedParameterTypes, (String)"boxedParameterTypes");
            this.declaringClass = declaringClass;
            this.declaringClassType = declaringClassType;
            this.parameterTypes = parameterTypes;
            this.boxedParameterTypes = boxedParameterTypes;
        }

        @NotNull
        public final PsiClass getDeclaringClass() {
            return this.declaringClass;
        }

        @NotNull
        public final Type getDeclaringClassType() {
            return this.declaringClassType;
        }

        @NotNull
        public final List<Type> getParameterTypes() {
            return this.parameterTypes;
        }

        @NotNull
        public final List<Type> getBoxedParameterTypes() {
            return this.boxedParameterTypes;
        }
    }
}

