/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import org.jmol.script.ContextToken;
import org.jmol.script.SV;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.ScriptFunction;

class ScriptFlowContext {
    private ScriptCompiler compiler;
    ContextToken token;
    int pt0;
    int ptDefault;
    ScriptFunction function;
    SV var;
    ScriptFlowContext parent;
    int lineStart;
    int commandStart;
    int ptLine;
    int ptCommand;
    boolean forceEndIf = true;
    String ident;
    int addLine;
    int tok0;
    public int ichCommand;
    short line0;

    ScriptFlowContext(ScriptCompiler compiler, ContextToken token, int pt0, ScriptFlowContext parent, int ich, short line0) {
        this.compiler = compiler;
        this.token = token;
        this.tok0 = token.tok;
        this.ident = (String)token.value;
        this.pt0 = pt0;
        this.line0 = line0;
        this.parent = parent;
        this.ichCommand = ich;
        short s = this.compiler.lineCurrent;
        this.ptLine = s;
        this.lineStart = s;
        this.commandStart = this.ptCommand = this.compiler.iCommand;
    }

    ScriptFlowContext getBreakableContext(int nLevelsUp) {
        ScriptFlowContext f = this;
        while (!(f == null || ScriptCompiler.isBreakableContext(f.token.tok) && nLevelsUp-- <= 0)) {
            f = f.parent;
        }
        return f;
    }

    boolean checkForceEndIf(int offset) {
        boolean test;
        if (this.ptCommand == this.compiler.iCommand && this.addLine > 0) {
            ++this.addLine;
        }
        boolean bl = this.forceEndIf && this.ptCommand < this.compiler.iCommand && this.ptLine + (this.addLine == 0 ? 0 : this.addLine + offset) == this.compiler.lineCurrent ? true : (test = false);
        if (test) {
            this.forceEndIf = false;
        }
        return test;
    }

    int setPt0(int pt0, boolean isDefault) {
        this.pt0 = pt0;
        if (isDefault) {
            this.ptDefault = pt0;
        }
        this.setLine();
        return pt0;
    }

    void setLine() {
        this.ptLine = this.compiler.lineCurrent;
        this.ptCommand = this.compiler.iCommand + 1;
    }

    public String toString() {
        return "ident " + this.ident + " line " + this.lineStart + " command " + this.commandStart;
    }

    String path() {
        String s = "";
        ScriptFlowContext f = this;
        while (f != null) {
            s = f.ident + "-" + s;
            f = f.parent;
        }
        return "[" + s + "]";
    }

    void setFunction(ScriptFunction function) {
        this.function = function;
    }
}

