/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models;

import java.util.Locale;
import org.hibernate.MappingException;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;

public class AccessTypePlacementException
extends MappingException {
    public AccessTypePlacementException(ClassDetails classDetails, MemberDetails memberDetails) {
        super(AccessTypePlacementException.craftMessage(classDetails, memberDetails));
    }

    private static String craftMessage(ClassDetails classDetails, MemberDetails memberDetails) {
        if (memberDetails.isField()) {
            return String.format(Locale.ROOT, "Field `%s.%s` defined `@Access(PROPERTY) - see section 2.3.2 of the specification", classDetails.getName(), memberDetails.getName());
        }
        return String.format(Locale.ROOT, "Method `%s.%s` defined `@Access(FIELD) - see section 2.3.2 of the specification", classDetails.getName(), memberDetails.getName());
    }
}

