/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.themes;

import java.io.File;
import java.util.Objects;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.theme.FolderThemeProvider;
import org.keycloak.theme.ThemeProvider;
import org.keycloak.theme.ThemeProviderFactory;

public class QuarkusFolderThemeProviderFactory
implements ThemeProviderFactory {
    private static final String CONFIG_DIR_KEY = "dir";
    private FolderThemeProvider themeProvider;

    public ThemeProvider create(KeycloakSession sessions) {
        return this.themeProvider;
    }

    public void init(Config.Scope config) {
        String configDir = config.get(CONFIG_DIR_KEY);
        File rootDir = this.getThemeRootDirWithFallback(configDir);
        this.themeProvider = new FolderThemeProvider(rootDir);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "folder";
    }

    private File getThemeRootDirWithFallback(String rootDirFromConfig) {
        File themeRootDir = new File(Objects.requireNonNullElseGet(rootDirFromConfig, Environment::getDefaultThemeRootDir));
        if (!themeRootDir.exists()) {
            return null;
        }
        return themeRootDir;
    }
}

