/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.logs.spi;

import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.logs.ConfigurableLogRecordExporterProvider;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.quarkus.opentelemetry.runtime.exporter.otlp.logs.NoopLogRecordExporter;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import org.jboss.logging.Logger;

public class LogsExporterCDIProvider
implements ConfigurableLogRecordExporterProvider {
    Logger log = Logger.getLogger((String)LogsExporterCDIProvider.class.getName());

    public LogRecordExporter createExporter(ConfigProperties configProperties) {
        Instance exporters = CDI.current().select(LogRecordExporter.class, new Annotation[]{Any.Literal.INSTANCE});
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("available exporters: " + exporters.stream().map(e -> e.getClass().getName()).reduce((a, b) -> a + ", " + b).orElse("none")));
        }
        if (exporters.isUnsatisfied()) {
            return NoopLogRecordExporter.INSTANCE;
        }
        this.log.debugf("using exporter: %s", (Object)((LogRecordExporter)exporters.get()).getClass().getName());
        return (LogRecordExporter)exporters.get();
    }

    public String getName() {
        return "cdi";
    }
}

