/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.keycloak.models.ClientModel;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class ConsentRequiredExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private Configuration configuration;

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        ClientCRUDContext clientUpdateContext = null;
        switch (context.getEvent()) {
            case REGISTER: {
                clientUpdateContext = (ClientCRUDContext)context;
                this.autoConfigure(clientUpdateContext.getProposedClientRepresentation());
                this.validate(clientUpdateContext.getProposedClientRepresentation());
                break;
            }
            case UPDATE: {
                clientUpdateContext = (ClientCRUDContext)context;
                this.autoConfigure(clientUpdateContext.getProposedClientRepresentation());
                this.beforeUpdate(clientUpdateContext.getTargetClient(), clientUpdateContext.getProposedClientRepresentation());
                break;
            }
            default: {
                return;
            }
        }
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "consent-required";
    }

    private void autoConfigure(ClientRepresentation proposedClient) throws ClientPolicyException {
        if (this.configuration.isAutoConfigure().booleanValue()) {
            proposedClient.setConsentRequired(Boolean.valueOf(true));
        }
    }

    private void validate(ClientRepresentation proposedClient) throws ClientPolicyException {
        if (proposedClient.isConsentRequired() == null || !proposedClient.isConsentRequired().booleanValue()) {
            throw new ClientPolicyException("invalid_registration", "Client is required to enable consentRequired");
        }
    }

    public void beforeUpdate(ClientModel clientToBeUpdated, ClientRepresentation proposedClient) throws ClientPolicyException {
        if (clientToBeUpdated == null) {
            return;
        }
        if (proposedClient.isConsentRequired() == null && clientToBeUpdated.isConsentRequired()) {
            return;
        }
        this.validate(proposedClient);
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="auto-configure")
        protected Boolean autoConfigure;

        public Boolean isAutoConfigure() {
            return this.autoConfigure;
        }

        public void setAutoConfigure(Boolean autoConfigure) {
            this.autoConfigure = autoConfigure;
        }
    }
}

