"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatAnomalyNumber = exports.SHOW_DECIMAL_NUMBER_THRESHOLD = exports.NO_PERMISSIONS_KEY_WORD = exports.DOES_NOT_HAVE_PERMISSIONS_KEY_WORD = exports.CANT_FIND_KEY_WORD = void 0;
exports.getClientBasedOnDataSource = getClientBasedOnDataSource;
exports.getFloorPlotTime = void 0;
exports.mapKeysDeep = mapKeysDeep;
exports.toSnake = exports.toFixedNumberForForecast = exports.toFixedNumberForAnomaly = exports.toFixedNumber = exports.toCamel = exports.prettifyErrorMessage = void 0;
var _lodash = require("lodash");
var _constants = require("./constants");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const SHOW_DECIMAL_NUMBER_THRESHOLD = exports.SHOW_DECIMAL_NUMBER_THRESHOLD = 0.01;
function mapKeysDeep(obj, fn) {
  if (Array.isArray(obj)) {
    return (0, _lodash.map)(obj, innerObj => mapKeysDeep(innerObj, fn));
  } else {
    //@ts-ignore
    return (0, _lodash.isPlainObject)(obj) ? (0, _lodash.mapValues)((0, _lodash.mapKeys)(obj, fn), value => mapKeysDeep(value, fn)) : obj;
  }
}
const toSnake = (value, key) => (0, _lodash.snakeCase)(key);
exports.toSnake = toSnake;
const toCamel = (value, key) => (0, _lodash.camelCase)(key);
exports.toCamel = toCamel;
const getFloorPlotTime = plotTime => {
  return Math.floor(plotTime / _constants.MIN_IN_MILLI_SECS) * _constants.MIN_IN_MILLI_SECS;
};
exports.getFloorPlotTime = getFloorPlotTime;
const toFixedNumber = (num, digits, base) => {
  var pow = Math.pow(base || 10, digits || 2);
  return Math.round(num * pow) / pow;
};

// 1.If num>0.01, will keep two digits;
// 2.If num<0.01, will use scientific notation, for example 0.001234 will become 1.23e-3
exports.toFixedNumber = toFixedNumber;
const toFixedNumberForAnomaly = num => {
  return num >= SHOW_DECIMAL_NUMBER_THRESHOLD ? toFixedNumber(num, 2) : Number(num.toExponential(2));
};
exports.toFixedNumberForAnomaly = toFixedNumberForAnomaly;
const formatAnomalyNumber = num => {
  return num >= SHOW_DECIMAL_NUMBER_THRESHOLD ? num.toFixed(2) : num.toExponential(2);
};
exports.formatAnomalyNumber = formatAnomalyNumber;
const PERMISSIONS_ERROR_PATTERN = /no permissions for \[(.+)\] and User \[name=(.+), backend_roles/;
const NO_PERMISSIONS_KEY_WORD = exports.NO_PERMISSIONS_KEY_WORD = 'no permissions';
const DOES_NOT_HAVE_PERMISSIONS_KEY_WORD = exports.DOES_NOT_HAVE_PERMISSIONS_KEY_WORD = 'does not have permissions';
const CANT_FIND_KEY_WORD = exports.CANT_FIND_KEY_WORD = "Can't find";
const prettifyErrorMessage = rawErrorMessage => {
  if ((0, _lodash.isEmpty)(rawErrorMessage) || rawErrorMessage === 'undefined') {
    return 'Unknown error is returned.';
  }
  const match = rawErrorMessage.match(PERMISSIONS_ERROR_PATTERN);
  if ((0, _lodash.isEmpty)(match)) {
    return rawErrorMessage;
  } else {
    return `User ${match[2]} has no permissions to [${match[1]}].`;
  }
};
exports.prettifyErrorMessage = prettifyErrorMessage;
function getClientBasedOnDataSource(context, dataSourceEnabled, request, dataSourceId, client) {
  if (dataSourceEnabled && dataSourceId && dataSourceId.trim().length != 0) {
    // client for remote cluster
    return context.dataSource.opensearch.legacy.getClient(dataSourceId).callAPI;
  } else {
    // fall back to default local cluster
    return client.asScoped(request).callAsCurrentUser;
  }
}

// 1.If abs(num)>=0.01, will keep two digits;
// 2.If abs(num)<0.01, will use scientific notation, for example 0.001234 will become 1.23e-3
const toFixedNumberForForecast = num => {
  return Math.abs(num) >= SHOW_DECIMAL_NUMBER_THRESHOLD ? toFixedNumber(num, 2) : Number(num.toExponential(2));
};
exports.toFixedNumberForForecast = toFixedNumberForForecast;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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