/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lifecycle.LifecycleListener;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.IndexModule;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.jobscheduler.JobSchedulerSettings;
import org.opensearch.jobscheduler.LegacyOpenDistroJobSchedulerSettings;
import org.opensearch.jobscheduler.ScheduledJobProvider;
import org.opensearch.jobscheduler.rest.action.RestGetJobDetailsAction;
import org.opensearch.jobscheduler.rest.action.RestGetLockAction;
import org.opensearch.jobscheduler.rest.action.RestGetLocksAction;
import org.opensearch.jobscheduler.rest.action.RestGetScheduledInfoAction;
import org.opensearch.jobscheduler.rest.action.RestReleaseLockAction;
import org.opensearch.jobscheduler.scheduler.JobScheduler;
import org.opensearch.jobscheduler.spi.JobSchedulerExtension;
import org.opensearch.jobscheduler.spi.ScheduledJobParser;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.jobscheduler.spi.schedule.ScheduleParser;
import org.opensearch.jobscheduler.spi.utils.LockService;
import org.opensearch.jobscheduler.sweeper.JobSweeper;
import org.opensearch.jobscheduler.transport.action.GetAllLocksAction;
import org.opensearch.jobscheduler.transport.action.GetScheduledInfoAction;
import org.opensearch.jobscheduler.transport.action.TransportGetAllLocksAction;
import org.opensearch.jobscheduler.transport.action.TransportGetScheduledInfoAction;
import org.opensearch.jobscheduler.utils.JobDetailsService;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.ExtensiblePlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.FixedExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.watcher.ResourceWatcherService;

public class JobSchedulerPlugin
extends Plugin
implements ActionPlugin,
ExtensiblePlugin,
SystemIndexPlugin {
    public static final String OPEN_DISTRO_JOB_SCHEDULER_THREAD_POOL_NAME = "open_distro_job_scheduler";
    public static final String JS_BASE_URI = "/_plugins/_job_scheduler";
    private static final Logger log = LogManager.getLogger(JobSchedulerPlugin.class);
    private JobSweeper sweeper;
    private JobScheduler scheduler;
    private LockService lockService;
    private Map<String, ScheduledJobProvider> indexToJobProviders;
    private Set<String> indicesToListen = new HashSet<String>();
    private JobDetailsService jobDetailsService;

    public JobSchedulerPlugin() {
        this.indexToJobProviders = new HashMap<String, ScheduledJobProvider>();
    }

    public Set<String> getIndicesToListen() {
        return this.indicesToListen;
    }

    public Map<String, ScheduledJobProvider> getIndexToJobProviders() {
        return this.indexToJobProviders;
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return Collections.singletonList(new SystemIndexDescriptor(".opendistro-job-scheduler-lock", "Stores lock documents used for plugin job execution"));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.lockService = new LockService(client, clusterService);
        this.jobDetailsService = new JobDetailsService(client, clusterService, this.indicesToListen, this.indexToJobProviders);
        this.scheduler = new JobScheduler(threadPool, this.lockService);
        this.sweeper = this.initSweeper(environment.settings(), client, clusterService, threadPool, xContentRegistry, this.scheduler, this.lockService, this.jobDetailsService);
        clusterService.addListener((ClusterStateListener)this.sweeper);
        clusterService.addLifecycleListener((LifecycleListener)this.sweeper);
        return List.of(this.lockService, this.scheduler, this.jobDetailsService);
    }

    public List<Setting<?>> getSettings() {
        ArrayList settingList = new ArrayList();
        settingList.add(LegacyOpenDistroJobSchedulerSettings.SWEEP_PAGE_SIZE);
        settingList.add(LegacyOpenDistroJobSchedulerSettings.REQUEST_TIMEOUT);
        settingList.add(LegacyOpenDistroJobSchedulerSettings.SWEEP_BACKOFF_MILLIS);
        settingList.add(LegacyOpenDistroJobSchedulerSettings.SWEEP_BACKOFF_RETRY_COUNT);
        settingList.add(LegacyOpenDistroJobSchedulerSettings.SWEEP_PERIOD);
        settingList.add(LegacyOpenDistroJobSchedulerSettings.JITTER_LIMIT);
        settingList.add(JobSchedulerSettings.SWEEP_PAGE_SIZE);
        settingList.add(JobSchedulerSettings.REQUEST_TIMEOUT);
        settingList.add(JobSchedulerSettings.SWEEP_BACKOFF_MILLIS);
        settingList.add(JobSchedulerSettings.SWEEP_BACKOFF_RETRY_COUNT);
        settingList.add(JobSchedulerSettings.SWEEP_PERIOD);
        settingList.add(JobSchedulerSettings.JITTER_LIMIT);
        return settingList;
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        int processorCount = OpenSearchExecutors.allocatedProcessors((Settings)settings);
        ArrayList executorBuilders = new ArrayList();
        executorBuilders.add((ExecutorBuilder<?>)new FixedExecutorBuilder(settings, OPEN_DISTRO_JOB_SCHEDULER_THREAD_POOL_NAME, processorCount, 200, "opendistro.jobscheduler.threadpool"));
        return executorBuilders;
    }

    public void onIndexModule(IndexModule indexModule) {
        if (indexModule.getIndex().getName().equals(".opensearch-job-scheduler-job-details")) {
            indexModule.addIndexOperationListener((IndexingOperationListener)this.jobDetailsService);
            log.info("JobDetailsService started listening to operations on index {}", (Object)".opensearch-job-scheduler-job-details");
        }
        if (this.indicesToListen.contains(indexModule.getIndex().getName())) {
            indexModule.addIndexOperationListener((IndexingOperationListener)this.sweeper);
            log.info("JobSweeper started listening to operations on index {}", (Object)indexModule.getIndex().getName());
        }
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        for (JobSchedulerExtension extension : loader.loadExtensions(JobSchedulerExtension.class)) {
            String jobType = extension.getJobType();
            String jobIndexName = extension.getJobIndex();
            ScheduledJobParser jobParser = extension.getJobParser();
            ScheduledJobRunner runner = extension.getJobRunner();
            if (this.indexToJobProviders.containsKey(jobIndexName)) continue;
            ScheduledJobProvider provider = new ScheduledJobProvider(jobType, jobIndexName, jobParser, runner);
            this.indexToJobProviders.put(jobIndexName, provider);
            this.indicesToListen.add(jobIndexName);
            log.info("Loaded scheduler extension: {}, index: {}", (Object)jobType, (Object)jobIndexName);
        }
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> registryEntries = new ArrayList<NamedXContentRegistry.Entry>();
        NamedXContentRegistry.Entry scheduleEntry = new NamedXContentRegistry.Entry(Schedule.class, new ParseField("schedule", new String[0]), ScheduleParser::parse);
        registryEntries.add(scheduleEntry);
        return registryEntries;
    }

    private JobSweeper initSweeper(Settings settings, Client client, ClusterService clusterService, ThreadPool threadPool, NamedXContentRegistry registry, JobScheduler scheduler, LockService lockService, JobDetailsService jobDetailsService) {
        return new JobSweeper(settings, client, clusterService, threadPool, registry, this.indexToJobProviders, scheduler, lockService, jobDetailsService);
    }

    public List getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        RestGetJobDetailsAction restGetJobDetailsAction = new RestGetJobDetailsAction(this.jobDetailsService);
        RestGetLockAction restGetLockAction = new RestGetLockAction(this.lockService);
        RestReleaseLockAction restReleaseLockAction = new RestReleaseLockAction(this.lockService);
        RestGetScheduledInfoAction restGetScheduledInfoAction = new RestGetScheduledInfoAction();
        RestGetLocksAction restGetAllLocksAction = new RestGetLocksAction();
        return List.of(restGetJobDetailsAction, restGetLockAction, restReleaseLockAction, restGetScheduledInfoAction, restGetAllLocksAction);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>(2);
        actions.add(new ActionPlugin.ActionHandler((ActionType)GetScheduledInfoAction.INSTANCE, TransportGetScheduledInfoAction.class, new Class[0]));
        actions.add(new ActionPlugin.ActionHandler((ActionType)GetAllLocksAction.INSTANCE, TransportGetAllLocksAction.class, new Class[0]));
        return actions;
    }
}

