/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.security.PatchOperation;
import org.opensearch.client.opensearch.security.PatchTenantResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class PatchTenantRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PatchTenantRequest> {
    @Nonnull
    private final List<PatchOperation> operations;
    @Nonnull
    private final String tenant;
    public static final JsonpDeserializer<PatchTenantRequest> _DESERIALIZER = PatchTenantRequest.createPatchTenantRequestDeserializer();
    public static final Endpoint<PatchTenantRequest, PatchTenantResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PatchTenantRequest, PatchTenantResponse>(request -> "PATCH", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_security/api/tenants/");
        SimpleEndpoint.pathEncode(request.tenant, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, PatchTenantResponse._DESERIALIZER);

    private PatchTenantRequest(Builder builder) {
        super(builder);
        this.operations = ApiTypeHelper.unmodifiableRequired(builder.operations, (Object)this, "operations");
        this.tenant = ApiTypeHelper.requireNonNull(builder.tenant, this, "tenant");
    }

    public static PatchTenantRequest of(Function<Builder, ObjectBuilder<PatchTenantRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<PatchOperation> operations() {
        return this.operations;
    }

    @Nonnull
    public final String tenant() {
        return this.tenant;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (PatchOperation item0 : this.operations) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static JsonpDeserializer<PatchTenantRequest> createPatchTenantRequestDeserializer() {
        JsonpDeserializer<List<PatchOperation>> valueDeserializer = JsonpDeserializer.arrayDeserializer(PatchOperation._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper) -> new Builder().operations((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper)).build());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.operations.hashCode();
        result = 31 * result + this.tenant.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchTenantRequest other = (PatchTenantRequest)o;
        return this.operations.equals(other.operations) && this.tenant.equals(other.tenant);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PatchTenantRequest> {
        private List<PatchOperation> operations;
        private String tenant;

        public Builder() {
        }

        private Builder(PatchTenantRequest o) {
            super(o);
            this.operations = Builder._listCopy(o.operations);
            this.tenant = o.tenant;
        }

        private Builder(Builder o) {
            super(o);
            this.operations = Builder._listCopy(o.operations);
            this.tenant = o.tenant;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder operations(List<PatchOperation> list) {
            this.operations = Builder._listAddAll(this.operations, list);
            return this;
        }

        @Nonnull
        public final Builder operations(PatchOperation value, PatchOperation ... values) {
            this.operations = Builder._listAdd(this.operations, value, values);
            return this;
        }

        @Nonnull
        public final Builder operations(Function<PatchOperation.Builder, ObjectBuilder<PatchOperation>> fn) {
            return this.operations(fn.apply(new PatchOperation.Builder()).build(), new PatchOperation[0]);
        }

        @Nonnull
        public final Builder tenant(String value) {
            this.tenant = value;
            return this;
        }

        @Override
        @Nonnull
        public PatchTenantRequest build() {
            this._checkSingleUse();
            return new PatchTenantRequest(this);
        }
    }
}

