/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStream;
import com.google.api.gax.rpc.BidiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStream;
import com.google.api.gax.rpc.ClientStreamReadyObserver;
import com.google.api.gax.rpc.ErrorDetails;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StateCheckingResponseObserver;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.storage.ResponseContentLifecycleManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import com.google.rpc.Status;
import com.google.storage.v2.BidiReadObjectError;
import com.google.storage.v2.BidiReadObjectRedirectedError;
import com.google.storage.v2.BidiWriteObjectRedirectedError;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

final class GrpcUtils {
    private GrpcUtils() {
    }

    static GrpcCallContext contextWithBucketName(String bucketName, GrpcCallContext baseContext) {
        if (bucketName != null && !bucketName.isEmpty()) {
            return baseContext.withExtraHeaders((Map)ImmutableMap.of((Object)"x-goog-request-params", (Object)ImmutableList.of((Object)String.format(Locale.US, "bucket=%s", bucketName))));
        }
        return baseContext;
    }

    static <C extends Closeable> void closeAll(Collection<C> closeables) throws IOException {
        IOException ioException = closeables.stream().filter(Objects::nonNull).map(stream -> {
            try {
                stream.close();
                return null;
            }
            catch (IOException e) {
                return e;
            }
        }).filter(Objects::nonNull).reduce(null, (l, r) -> {
            if (l != null) {
                l.addSuppressed((Throwable)r);
                return l;
            }
            return r;
        }, (l, r) -> l);
        if (ioException != null) {
            throw ioException;
        }
    }

    static @Nullable BidiReadObjectRedirectedError getBidiReadObjectRedirectedError(Throwable t) {
        return GrpcUtils.findFirstPackedAny(t, BidiReadObjectRedirectedError.class);
    }

    static @Nullable BidiWriteObjectRedirectedError getBidiWriteObjectRedirectedError(Throwable t) {
        return GrpcUtils.findFirstPackedAny(t, BidiWriteObjectRedirectedError.class);
    }

    static @Nullable BidiReadObjectError getBidiReadObjectError(Throwable t) {
        return GrpcUtils.findFirstPackedAny(t, BidiReadObjectError.class);
    }

    static ApiException statusToApiException(Status status) {
        io.grpc.Status grpcStatus = io.grpc.Status.fromCodeValue((int)status.getCode());
        if (!status.getMessage().isEmpty()) {
            grpcStatus = grpcStatus.withDescription(status.getMessage());
        }
        StatusRuntimeException cause = grpcStatus.asRuntimeException();
        return ApiExceptionFactory.createException((Throwable)cause, (StatusCode)GrpcStatusCode.of((Status.Code)grpcStatus.getCode()), (boolean)false);
    }

    private static <M extends Message> @Nullable M findFirstPackedAny(Throwable t, Class<M> clazz) {
        ApiException apiException;
        ErrorDetails errorDetails;
        if (t instanceof ApiException && (errorDetails = (apiException = (ApiException)t).getErrorDetails()) != null) {
            return (M)errorDetails.getMessage(clazz);
        }
        return null;
    }

    static <R> StateCheckingResponseObserver<R> decorateAsStateChecking(ResponseObserver<R> delegate) {
        return new DecoratingStateCheckingResponseObserver(delegate);
    }

    private static final class DecoratingStateCheckingResponseObserver<Response>
    extends StateCheckingResponseObserver<Response> {
        private final ResponseObserver<Response> delegate;

        private DecoratingStateCheckingResponseObserver(ResponseObserver<Response> delegate) {
            this.delegate = delegate;
        }

        protected void onStartImpl(StreamController controller) {
            this.delegate.onStart(controller);
        }

        protected void onResponseImpl(Response response) {
            this.delegate.onResponse(response);
        }

        protected void onErrorImpl(Throwable t) {
            this.delegate.onError(t);
        }

        protected void onCompleteImpl() {
            this.delegate.onComplete();
        }
    }

    static final class ZeroCopyServerStreamingCallable<RequestT, ResponseT>
    extends ServerStreamingCallable<RequestT, ResponseT> {
        private final ServerStreamingCallable<RequestT, ResponseT> delegate;
        private final ResponseContentLifecycleManager<ResponseT> responseContentLifecycleManager;

        ZeroCopyServerStreamingCallable(ServerStreamingCallable<RequestT, ResponseT> delegate, ResponseContentLifecycleManager<ResponseT> responseContentLifecycleManager) {
            this.delegate = delegate;
            this.responseContentLifecycleManager = responseContentLifecycleManager;
        }

        public ServerStream<ResponseT> call(RequestT request) {
            return this.delegate.call(request);
        }

        public ServerStream<ResponseT> call(RequestT request, ApiCallContext context) {
            return this.delegate.call(request, context);
        }

        public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
            this.delegate.call(request, responseObserver, context);
        }

        public void call(RequestT request, ResponseObserver<ResponseT> responseObserver) {
            this.delegate.call(request, responseObserver);
        }

        public UnaryCallable<RequestT, ResponseT> first() {
            return this.delegate.first();
        }

        public UnaryCallable<RequestT, List<ResponseT>> all() {
            return this.delegate.all();
        }

        @Deprecated
        public void serverStreamingCall(RequestT request, ApiStreamObserver<ResponseT> responseObserver, ApiCallContext context) {
            this.delegate.serverStreamingCall(request, responseObserver, context);
        }

        @Deprecated
        public void serverStreamingCall(RequestT request, ApiStreamObserver<ResponseT> responseObserver) {
            this.delegate.serverStreamingCall(request, responseObserver);
        }

        @Deprecated
        public Iterator<ResponseT> blockingServerStreamingCall(RequestT request, ApiCallContext context) {
            return this.delegate.blockingServerStreamingCall(request, context);
        }

        @Deprecated
        public Iterator<ResponseT> blockingServerStreamingCall(RequestT request) {
            return this.delegate.blockingServerStreamingCall(request);
        }

        public ZeroCopyServerStreamingCallable<RequestT, ResponseT> withDefaultCallContext(ApiCallContext defaultCallContext) {
            return new ZeroCopyServerStreamingCallable<RequestT, ResponseT>(this.delegate.withDefaultCallContext(defaultCallContext), this.responseContentLifecycleManager);
        }

        ResponseContentLifecycleManager<ResponseT> getResponseContentLifecycleManager() {
            return this.responseContentLifecycleManager;
        }
    }

    static final class ZeroCopyBidiStreamingCallable<RequestT, ResponseT>
    extends BidiStreamingCallable<RequestT, ResponseT> {
        private final BidiStreamingCallable<RequestT, ResponseT> delegate;
        private final ResponseContentLifecycleManager<ResponseT> responseContentLifecycleManager;

        ZeroCopyBidiStreamingCallable(BidiStreamingCallable<RequestT, ResponseT> delegate, ResponseContentLifecycleManager<ResponseT> responseContentLifecycleManager) {
            this.delegate = delegate;
            this.responseContentLifecycleManager = responseContentLifecycleManager;
        }

        public ClientStream<RequestT> internalCall(ResponseObserver<ResponseT> responseObserver, ClientStreamReadyObserver<RequestT> onReady, ApiCallContext context) {
            return this.delegate.internalCall(responseObserver, onReady, context);
        }

        public void call(BidiStreamObserver<RequestT, ResponseT> bidiObserver) {
            this.delegate.call(bidiObserver);
        }

        public void call(BidiStreamObserver<RequestT, ResponseT> bidiObserver, ApiCallContext context) {
            this.delegate.call(bidiObserver, context);
        }

        public BidiStream<RequestT, ResponseT> call() {
            return this.delegate.call();
        }

        public BidiStream<RequestT, ResponseT> call(ApiCallContext context) {
            return this.delegate.call(context);
        }

        public ClientStream<RequestT> splitCall(ResponseObserver<ResponseT> responseObserver) {
            return this.delegate.splitCall(responseObserver);
        }

        public ClientStream<RequestT> splitCall(ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
            return this.delegate.splitCall(responseObserver, context);
        }

        @Deprecated
        public ApiStreamObserver<RequestT> bidiStreamingCall(ApiStreamObserver<ResponseT> responseObserver, ApiCallContext context) {
            return this.delegate.bidiStreamingCall(responseObserver, context);
        }

        @Deprecated
        public ApiStreamObserver<RequestT> bidiStreamingCall(ApiStreamObserver<ResponseT> responseObserver) {
            return this.delegate.bidiStreamingCall(responseObserver);
        }

        public ZeroCopyBidiStreamingCallable<RequestT, ResponseT> withDefaultCallContext(ApiCallContext defaultCallContext) {
            return new ZeroCopyBidiStreamingCallable<RequestT, ResponseT>(this.delegate.withDefaultCallContext(defaultCallContext), this.responseContentLifecycleManager);
        }

        ResponseContentLifecycleManager<ResponseT> getResponseContentLifecycleManager() {
            return this.responseContentLifecycleManager;
        }
    }
}

