/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.graphic;

import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeSeries;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.graphic.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.graphic.Panels;

public class PanelsAnalog
extends Panels {
    private final TimeSeries timeSeries;
    private final Double initialState;
    private final Integer ticksEvery;

    public PanelsAnalog(TimingRuler ruler, ISkinParam skinParam, int suggestedHeight, Style style, TimeSeries timeSeries, List<TimeConstraint> constraints, Double initialState, Integer ticksEvery) {
        super(ruler, skinParam, suggestedHeight, style, null, constraints);
        this.timeSeries = timeSeries;
        this.initialState = initialState;
        this.ticksEvery = ticksEvery;
    }

    @Override
    public double getFullHeight(StringBounder stringBounder) {
        return this.getHeightForConstraints(stringBounder) + (double)this.suggestedHeight;
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        if (tick == null) {
            return null;
        }
        double x = this.ruler.getPosInPixel(tick);
        double value = this.timeSeries.getValueAt(tick);
        return new IntricatedPoint(new XPoint2D(x, this.getYpos(stringBounder, value)), new XPoint2D(x, this.getYpos(stringBounder, value)));
    }

    private double getYpos(StringBounder stringBounder, double value) {
        double y = (value - this.timeSeries.getMin()) * ((double)this.suggestedHeight - 16.0) / (this.timeSeries.getMax() - this.timeSeries.getMin());
        return this.getHeightForConstraints(stringBounder) + (double)this.suggestedHeight - 8.0 - y;
    }

    @Override
    public void drawLeftPanel(UGraphic ug, double fullAvailableWidth) {
        if (this.ticksEvery == null) {
            this.drawScaleLabel(ug, this.timeSeries.getMin(), fullAvailableWidth);
            this.drawScaleLabel(ug, this.timeSeries.getMax(), fullAvailableWidth);
        } else {
            int first = (int)Math.ceil(this.timeSeries.getMin());
            int last = (int)Math.floor(this.timeSeries.getMax());
            for (int i = first; i <= last; ++i) {
                if (i % this.ticksEvery != 0) continue;
                this.drawScaleLabel(ug, i, fullAvailableWidth);
            }
        }
    }

    @Override
    public final double getLeftPanelWidth(StringBounder stringBounder) {
        return 5.0 + this.getMaxWidthForTicks(stringBounder);
    }

    private double getMaxWidthForTicks(StringBounder stringBounder) {
        if (this.ticksEvery == null) {
            return Math.max(this.getWidthLabel(stringBounder, this.timeSeries.getMin()), this.getWidthLabel(stringBounder, this.timeSeries.getMax()));
        }
        double result = 0.0;
        int first = (int)Math.ceil(this.timeSeries.getMin());
        int last = (int)Math.floor(this.timeSeries.getMax());
        for (int i = first; i <= last; ++i) {
            if (i % this.ticksEvery != 0) continue;
            result = Math.max(result, this.getWidthLabel(stringBounder, i));
        }
        return result;
    }

    private double getWidthLabel(StringBounder stringBounder, double value) {
        TextBlock label = this.getTextBlock(value);
        XDimension2D dim = label.calculateDimension(stringBounder);
        return dim.getWidth();
    }

    private void drawScaleLabel(UGraphic ug, double value, double fullAvailableWidth) {
        TextBlock label = this.getTextBlock(value);
        XDimension2D dim = label.calculateDimension(ug.getStringBounder());
        ug = ug.apply(UTranslate.dx(fullAvailableWidth - dim.getWidth() - 2.0));
        label.drawU(ug.apply(UTranslate.dy(this.getYpos(ug.getStringBounder(), value) - dim.getHeight() / 2.0)));
    }

    private TextBlock getTextBlock(double value) {
        String formattedValue = this.timeSeries.getDisplayValue(value);
        Display display = Display.getWithNewlines(this.skinParam.getPragma(), formattedValue);
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    private void drawTickHlines(UGraphic ug) {
        ug = TimingRuler.applyForVLines(ug, this.style, this.skinParam);
        int first = (int)Math.ceil(this.timeSeries.getMin());
        int last = (int)Math.floor(this.timeSeries.getMax());
        ULine hline = ULine.hline(this.ruler.getWidth());
        for (int i = first; i <= last; ++i) {
            if (i % this.ticksEvery != 0) continue;
            ug.apply(UTranslate.dy(this.getYpos(ug.getStringBounder(), i))).draw(hline);
        }
    }

    @Override
    public void drawRightPanel(UGraphic ug) {
        if (this.ticksEvery != null) {
            this.drawTickHlines(ug);
        }
        ug = this.getContext().apply(ug);
        double lastx = 0.0;
        double lastValue = this.initialState == null ? 0.0 : this.initialState;
        for (Map.Entry<TimeTick, Double> ent : this.timeSeries.entrySet()) {
            double y1 = this.getYpos(ug.getStringBounder(), lastValue);
            double y2 = this.getYpos(ug.getStringBounder(), ent.getValue());
            double x = this.ruler.getPosInPixel(ent.getKey());
            ug.apply(new UTranslate(lastx, y1)).draw(new ULine(x - lastx, y2 - y1));
            lastx = x;
            lastValue = ent.getValue();
        }
        ug.apply(new UTranslate(lastx, this.getYpos(ug.getStringBounder(), lastValue))).draw(ULine.hline(this.ruler.getWidth() - lastx));
        this.drawConstraints(ug.apply(UTranslate.dy(this.getHeightForConstraints(ug.getStringBounder()))));
    }

    public void setBounds(String min, String max) {
        this.timeSeries.setBounds(min, max);
    }
}

