/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.huggingFace.service;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.python.community.impl.huggingFace.cache.HuggingFaceCacheFillService;
import com.intellij.python.community.impl.huggingFace.service.HuggingFaceLibrariesTracker;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.python.packaging.common.PythonPackageManagementListener;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.management.PythonPackageManagerExt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/python/community/impl/huggingFace/service/HuggingFaceLibrariesTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "isAnyHFLibraryInstalled", "", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "cacheFillService", "Lcom/intellij/python/community/impl/huggingFace/cache/HuggingFaceCacheFillService;", "relevantLibraries", "", "", "setupSdkListener", "", "detachSdkListener", "getProjectPythonSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "updateHFLibraryInstallStatus", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isAnyHFLibraryInstalledInSdk", "sdk", "(Lcom/intellij/openapi/projectRoots/Sdk;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "intellij.python.community.impl.huggingFace"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHuggingFaceLibrariesTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HuggingFaceLibrariesTracker.kt\ncom/intellij/python/community/impl/huggingFace/service/HuggingFaceLibrariesTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1761#2,3:84\n*S KotlinDebug\n*F\n+ 1 HuggingFaceLibrariesTracker.kt\ncom/intellij/python/community/impl/huggingFace/service/HuggingFaceLibrariesTracker\n*L\n77#1:84,3\n*E\n"})
public final class HuggingFaceLibrariesTracker
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    private volatile boolean isAnyHFLibraryInstalled;
    @Nullable
    private MessageBusConnection connection;
    @NotNull
    private final HuggingFaceCacheFillService cacheFillService;
    @NotNull
    private final Set<String> relevantLibraries;

    public HuggingFaceLibrariesTracker(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.connection = this.project.getMessageBus().connect((Disposable)this);
        Object object = this.project.getService(HuggingFaceCacheFillService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        this.cacheFillService = (HuggingFaceCacheFillService)object;
        Object[] objectArray = new String[]{"diffusers", "transformers", "allennlp", "spacy", "asteroid", "flair", "keras", "sentence-transformers", "stable-baselines3", "adapters", "huggingface_hub"};
        this.relevantLibraries = SetsKt.setOf((Object[])objectArray);
        this.setupSdkListener();
    }

    public final boolean isAnyHFLibraryInstalled() {
        return this.isAnyHFLibraryInstalled;
    }

    private final void setupSdkListener() {
        block0: {
            MessageBusConnection messageBusConnection = this.connection;
            if (messageBusConnection == null) break block0;
            messageBusConnection.subscribe(PythonPackageManager.Companion.getPACKAGE_MANAGEMENT_TOPIC(), (Object)new PythonPackageManagementListener(this){
                final /* synthetic */ HuggingFaceLibrariesTracker this$0;
                {
                    this.this$0 = $receiver;
                }

                public void packagesChanged(Sdk sdk2) {
                    Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
                    Sdk projectSdk = HuggingFaceLibrariesTracker.access$getProjectPythonSdk(this.this$0);
                    if (Intrinsics.areEqual((Object)sdk2, (Object)projectSdk)) {
                        BuildersKt.launch$default((CoroutineScope)HuggingFaceLibrariesTracker.access$getCoroutineScope$p(this.this$0), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ HuggingFaceLibrariesTracker this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = HuggingFaceLibrariesTracker.access$updateHFLibraryInstallStatus(this.this$0, (Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                    }
                }
            });
        }
    }

    private final void detachSdkListener() {
        MessageBusConnection messageBusConnection = this.connection;
        if (messageBusConnection != null) {
            messageBusConnection.disconnect();
        }
        this.connection = null;
    }

    private final Sdk getProjectPythonSdk() {
        return PythonSdkUtil.findPythonSdk((Module)ArraysKt.firstOrNull((Object[])ProjectUtil.getModules((Project)this.project)));
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateHFLibraryInstallStatus(Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateHFLibraryInstallStatus.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ HuggingFaceLibrariesTracker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HuggingFaceLibrariesTracker.access$updateHFLibraryInstallStatus(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.isAnyHFLibraryInstalled) {
                    return Unit.INSTANCE;
                }
                v0 = this.getProjectPythonSdk();
                if (v0 == null) {
                    return Unit.INSTANCE;
                }
                sdk = v0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)sdk);
                $continuation.label = 1;
                v1 = this.isAnyHFLibraryInstalledInSdk(sdk, (Continuation<? super Boolean>)$continuation);
                if (v1 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                sdk = (Sdk)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                if (((Boolean)v1).booleanValue()) {
                    this.isAnyHFLibraryInstalled = true;
                    this.cacheFillService.triggerCacheFillIfNeeded();
                    this.detachSdkListener();
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object isAnyHFLibraryInstalledInSdk(Sdk sdk, Continuation<? super Boolean> $completion) {
        block8: {
            if (!($completion instanceof isAnyHFLibraryInstalledInSdk.1)) ** GOTO lbl-1000
            var11_3 = $completion;
            if ((var11_3.label & -2147483648) != 0) {
                var11_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ HuggingFaceLibrariesTracker this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return HuggingFaceLibrariesTracker.access$isAnyHFLibraryInstalledInSdk(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    packageManager = PythonPackageManager.Companion.forSdk(this.project, sdk);
                    $this$any$iv = this.relevantLibraries;
                    $i$f$any = 0;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl18
                    v0 = false;
                    break block8;
lbl18:
                    // 1 sources

                    var6_9 = $this$any$iv.iterator();
lbl19:
                    // 2 sources

                    while (var6_9.hasNext()) {
                        element$iv = var6_9.next();
                        lib = (String)element$iv;
                        $i$a$-any-HuggingFaceLibrariesTracker$isAnyHFLibraryInstalledInSdk$2 = 0;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)sdk);
                        $continuation.L$1 = packageManager;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$any$iv);
                        $continuation.L$3 = var6_9;
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)lib);
                        $continuation.I$0 = $i$f$any;
                        $continuation.I$1 = $i$a$-any-HuggingFaceLibrariesTracker$isAnyHFLibraryInstalledInSdk$2;
                        $continuation.label = 1;
                        v1 = PythonPackageManagerExt.hasInstalledPackage$default(packageManager, lib, null, (Continuation)$continuation, 2, null);
                        if (v1 == var12_5) {
                            return var12_5;
                        }
                        ** GOTO lbl48
                    }
                    break;
                }
                case 1: {
                    $i$a$-any-HuggingFaceLibrariesTracker$isAnyHFLibraryInstalledInSdk$2 = $continuation.I$1;
                    $i$f$any = $continuation.I$0;
                    lib = (String)$continuation.L$5;
                    element$iv = $continuation.L$4;
                    var6_9 = (Iterator<T>)$continuation.L$3;
                    $this$any$iv = (Iterable)$continuation.L$2;
                    packageManager = (PythonPackageManager)$continuation.L$1;
                    sdk = (Sdk)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl48:
                    // 2 sources

                    if (!((Boolean)v1).booleanValue()) ** GOTO lbl19
                    v0 = true;
                    break block8;
                }
            }
            v0 = false;
        }
        return Boxing.boxBoolean((boolean)v0);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void dispose() {
        this.detachSdkListener();
    }

    public static final /* synthetic */ Sdk access$getProjectPythonSdk(HuggingFaceLibrariesTracker $this) {
        return $this.getProjectPythonSdk();
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(HuggingFaceLibrariesTracker $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ Object access$updateHFLibraryInstallStatus(HuggingFaceLibrariesTracker $this, Continuation $completion) {
        return $this.updateHFLibraryInstallStatus((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$isAnyHFLibraryInstalledInSdk(HuggingFaceLibrariesTracker $this, Sdk sdk2, Continuation $completion) {
        return $this.isAnyHFLibraryInstalledInSdk(sdk2, (Continuation<? super Boolean>)$completion);
    }
}

