/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bibgls.bib2gls.GlsResource;
import com.dickimawbooks.bibgls.bib2gls.GroupTitle;
import com.dickimawbooks.bibgls.bib2gls.NumberGroupTitle;
import com.dickimawbooks.bibgls.bib2gls.SortComparator;
import com.dickimawbooks.bibgls.bib2gls.SortSettings;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Vector;

public class Bib2GlsEntryNumericComparator
extends SortComparator {
    private String sort;
    private String sortMethod;
    private NumberFormat numberFormat;

    public Bib2GlsEntryNumericComparator(Bib2Gls bib2Gls, Vector<Bib2GlsEntry> vector, SortSettings sortSettings, String string, String string2, String string3, boolean bl) {
        super(bib2Gls, vector, sortSettings, string, string2, string3, bl);
        this.sortMethod = sortSettings.getMethod();
        this.sort = sortSettings.getUnderlyingMethod();
        Locale locale = sortSettings.getNumberLocale();
        if (this.sort.equals("numeric")) {
            this.numberFormat = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
        } else if (this.sort.equals("currency")) {
            this.numberFormat = locale == null ? NumberFormat.getCurrencyInstance() : NumberFormat.getCurrencyInstance(locale);
        } else if (this.sort.equals("percent")) {
            this.numberFormat = locale == null ? NumberFormat.getPercentInstance() : NumberFormat.getPercentInstance(locale);
        } else if (this.sort.equals("numberformat")) {
            DecimalFormatSymbols decimalFormatSymbols = locale == null ? DecimalFormatSymbols.getInstance() : DecimalFormatSymbols.getInstance(locale);
            this.numberFormat = new DecimalFormat(sortSettings.getNumberFormat(), decimalFormatSymbols);
        }
    }

    @Override
    protected boolean useSortSuffix() {
        return false;
    }

    @Override
    protected String adjustSort(Bib2GlsEntry bib2GlsEntry, String string) {
        Number number;
        block11: {
            String string2 = bib2GlsEntry.getId();
            number = null;
            try {
                if (this.numberFormat != null) {
                    number = this.numberFormat.parse(string);
                    break block11;
                }
                if (this.sort.equals("integer")) {
                    int n = string.indexOf(".");
                    if (n == -1) {
                        number = Integer.valueOf(string);
                    } else {
                        float f = Float.parseFloat(string);
                        number = (int)f;
                        string = "" + number;
                    }
                    break block11;
                }
                if (this.sort.equals("float")) {
                    number = Float.valueOf(string);
                    break block11;
                }
                if (this.sort.equals("double")) {
                    number = Double.valueOf(string);
                    break block11;
                }
                if (this.sort.equals("hex")) {
                    number = Integer.valueOf(string, 16);
                    break block11;
                }
                if (this.sort.equals("octal")) {
                    number = Integer.valueOf(string, 8);
                    break block11;
                }
                if (this.sort.equals("binary")) {
                    number = Integer.valueOf(string, 2);
                    break block11;
                }
                throw new IllegalArgumentException("Unrecognised numeric sort option: " + this.sortMethod);
            }
            catch (NumberFormatException | ParseException exception) {
                this.bib2gls.warning(this.bib2gls.getMessage("warning.cant.parse.sort", string, string2));
                string = "0";
                number = 0;
            }
        }
        bib2GlsEntry.setNumericSort(number);
        return string;
    }

    @Override
    protected long getDefaultGroupId(Bib2GlsEntry bib2GlsEntry, int n, Object object) {
        return ((Number)object).longValue();
    }

    @Override
    protected GroupTitle createDefaultGroupTitle(int n, Object object, String string, String string2) {
        return new NumberGroupTitle(this.bib2gls, (Number)object, string, string2);
    }

    @Override
    protected String updateSortValue(Bib2GlsEntry bib2GlsEntry, Vector<Bib2GlsEntry> vector) {
        String string = super.updateSortValue(bib2GlsEntry, vector);
        String string2 = bib2GlsEntry.getId();
        Number number = bib2GlsEntry.getNumericSort();
        GlsResource glsResource = this.bib2gls.getCurrentResource();
        String string3 = this.getType(bib2GlsEntry);
        if (bib2GlsEntry.getFieldValue(this.groupField) == null && glsResource.useGroupField(bib2GlsEntry, vector)) {
            this.setGroupTitle(bib2GlsEntry, -1, number, string, string3);
        }
        if (this.bib2gls.isVerbose()) {
            this.bib2gls.verbose(String.format("%s -> '%s'", string2, string));
        }
        return string;
    }

    @Override
    protected int compare(Number number, Number number2) {
        double d;
        if (number instanceof Integer && number2 instanceof Integer) {
            return ((Integer)number).compareTo((Integer)number2);
        }
        if (number instanceof Float && number2 instanceof Float) {
            return ((Float)number).compareTo((Float)number2);
        }
        if (number instanceof Double && number2 instanceof Double) {
            return ((Double)number).compareTo((Double)number2);
        }
        if (number instanceof Long && number2 instanceof Long) {
            return ((Long)number).compareTo((Long)number2);
        }
        double d2 = number.doubleValue();
        if (d2 == (d = number2.doubleValue())) {
            return 0;
        }
        return d2 < d ? -1 : 1;
    }

    @Override
    protected int compareElements(Bib2GlsEntry bib2GlsEntry, Bib2GlsEntry bib2GlsEntry2) {
        Number number = bib2GlsEntry.getNumericSort();
        Number number2 = bib2GlsEntry2.getNumericSort();
        return this.compare(number, number2);
    }
}

