/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.util.GraphicsUtilities;

public class PainterPaint<T>
implements Paint {
    private final PainterPaintContext<T> context;

    public PainterPaint(Painter<T> painter, T object) {
        this.context = new PainterPaintContext<T>(painter, object);
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return this.context;
    }

    @Override
    public int getTransparency() {
        return 2;
    }

    protected static class PainterPaintContext<T>
    implements PaintContext {
        private Painter<T> painter;
        private T object;
        private BufferedImage saved;

        public PainterPaintContext(Painter<T> painter, T object) {
            painter.getClass();
            this.painter = painter;
            this.object = object;
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            if (this.saved == null) {
                return GraphicsUtilities.createCompatibleImage(1, 1).getColorModel();
            }
            return this.saved.getColorModel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Raster getRaster(int x, int y, int w, int h) {
            if (this.saved == null || this.saved.getWidth() != w || this.saved.getHeight() != h) {
                this.saved = GraphicsUtilities.createCompatibleImage(w, h);
                Graphics2D g2d = this.saved.createGraphics();
                try {
                    if (this.painter instanceof AbstractPainter) {
                        ((AbstractPainter)this.painter).setInPaintContext(true);
                    }
                    this.painter.paint(g2d, this.object, w, h);
                }
                finally {
                    g2d.dispose();
                    if (this.painter instanceof AbstractPainter) {
                        ((AbstractPainter)this.painter).setInPaintContext(false);
                    }
                }
            }
            return this.saved.getData();
        }
    }
}

