/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.gbase8s.model;

import java.lang.reflect.Field;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.gbase8s.GBase8sUtils;
import org.jkiss.dbeaver.ext.gbase8s.model.GBase8sDataType;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericExecutionContext;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;

public class GBase8sDataSource
extends GenericDataSource {
    private static final Log log = Log.getLog(GBase8sDataType.class);

    public GBase8sDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new GenericSQLDialect());
    }

    protected JDBCExecutionContext createExecutionContext(JDBCRemoteInstance instance, String type) {
        this.replaceConnector4GetActiveDB(this.container);
        return new GenericExecutionContext(instance, type);
    }

    void replaceConnector4GetActiveDB(DBPDataSourceContainer container) {
        DBPDriver driver = container.getDriver();
        String getActiveDBQuery = CommonUtils.toString((Object)driver.getDriverParameter("query-get-active-db"));
        getActiveDBQuery = GBase8sUtils.isOracleSqlMode(container) ? getActiveDBQuery.replaceFirst("\\?", ".") : getActiveDBQuery.replaceFirst("\\?", ":");
        try {
            Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("queryGetActiveDB");
            field.setAccessible(true);
            field.set((Object)this, getActiveDBQuery);
        }
        catch (Exception e) {
            log.error((Object)"Failed to replace the connector of the database/table in queryGetActiveDB", (Throwable)e);
        }
    }
}

