/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.awt.Color;
import java.awt.Point;
import java.util.Optional;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.link.ConnectorArrows;
import org.freeplane.features.link.ConnectorProperties;
import org.freeplane.features.link.ConnectorShape;
import org.freeplane.features.link.NodeLinkModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeRelativePath;
import org.freeplane.features.styles.IStyle;

public class ConnectorModel
extends NodeLinkModel {
    private final ConnectorProperties connectorProperties;

    public ConnectorModel(NodeModel source, String targetID) {
        this(source, targetID, new ConnectorProperties());
    }

    public ConnectorModel(NodeModel source, String targetID, ConnectorArrows connectorEnds, int[] dash, Color color, int alpha, ConnectorShape shape, int width, String labelFontFamily, int labelFontSize) {
        this(source, targetID, new ConnectorProperties(connectorEnds, dash, color, alpha, shape, width, labelFontFamily, labelFontSize));
    }

    private ConnectorModel(NodeModel source, String targetID, ConnectorProperties connectorProperties) {
        super(source, targetID);
        assert (source != null);
        this.connectorProperties = connectorProperties;
    }

    public boolean isVisible(Filter filter) {
        return this.getTarget() != null && (filter == null || filter.isVisible(this));
    }

    public Optional<ConnectorShape> getShape() {
        return this.connectorProperties.getShape();
    }

    public void setShape(Optional<ConnectorShape> shape) {
        this.connectorProperties.setShape(shape);
    }

    public Optional<int[]> getDash() {
        return this.connectorProperties.getDash();
    }

    public void setDash(Optional<int[]> dash) {
        this.connectorProperties.setDash(dash);
    }

    public Optional<Color> getColor() {
        return this.connectorProperties.getColor();
    }

    public Point getEndInclination() {
        return this.connectorProperties.getEndInclination();
    }

    public Optional<String> getSourceLabel() {
        return this.connectorProperties.getSourceLabel();
    }

    public Optional<String> getMiddleLabel() {
        return this.connectorProperties.getMiddleLabel();
    }

    public Optional<String> getTargetLabel() {
        return this.connectorProperties.getTargetLabel();
    }

    public Point getStartInclination() {
        return this.connectorProperties.getStartInclination();
    }

    public Optional<Integer> getWidth() {
        return this.connectorProperties.getWidth();
    }

    public void setColor(Optional<Color> color) {
        this.connectorProperties.setColor(color);
    }

    public IStyle getStyle() {
        return this.connectorProperties.getStyle();
    }

    public void setStyle(IStyle style) {
        this.connectorProperties.setStyle(style);
    }

    public Optional<ConnectorArrows> getArrows() {
        return this.connectorProperties.getArrows();
    }

    public void setArrows(Optional<ConnectorArrows> arrows) {
        this.connectorProperties.setArrows(arrows);
    }

    public void setEndInclination(Point endInclination) {
        this.connectorProperties.setEndInclination(endInclination);
    }

    public void setMiddleLabel(String middleLabel) {
        this.connectorProperties.setMiddleLabel(middleLabel);
    }

    public void setSourceLabel(String label) {
        this.connectorProperties.setSourceLabel(label);
    }

    public void setStartInclination(Point startInclination) {
        this.connectorProperties.setStartInclination(startInclination);
    }

    public void setTargetLabel(String targetLabel) {
        this.connectorProperties.setTargetLabel(targetLabel);
    }

    public void setWidth(Optional<Integer> width) {
        this.connectorProperties.setWidth(width);
    }

    public void setAlpha(Optional<Integer> alpha) {
        this.connectorProperties.setAlpha(alpha);
    }

    public Optional<Integer> getAlpha() {
        return this.connectorProperties.getAlpha();
    }

    public Optional<String> getLabelFontFamily() {
        return this.connectorProperties.getLabelFontFamily();
    }

    public void setLabelFontFamily(Optional<String> labelFontFamily) {
        this.connectorProperties.setLabelFontFamily(labelFontFamily);
    }

    public Optional<Integer> getLabelFontSize() {
        return this.connectorProperties.getLabelFontSize();
    }

    public void setLabelFontSize(Optional<Integer> labelFontSize) {
        this.connectorProperties.setLabelFontSize(labelFontSize);
    }

    public void changeInclination(int deltaX, int deltaY, NodeModel selectionRoot, NodeModel linkedNodeView, Point changedInclination) {
        this.connectorProperties.changeInclination(deltaX, deltaY, selectionRoot, linkedNodeView, changedInclination);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.connectorProperties.hashCode();
        result = 31 * result + this.getSource().hashCode();
        String targetID = this.getTargetID();
        if (targetID == null) {
            return result;
        }
        result = 31 * result + targetID.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectorModel other = (ConnectorModel)obj;
        if (!this.connectorProperties.equals(other.connectorProperties) || !this.getSource().equals(other.getSource())) {
            return false;
        }
        String targetID = this.getTargetID();
        if (targetID == null) {
            return other.getTargetID() == null;
        }
        return targetID.equals(other.getTargetID());
    }

    @Override
    public NodeLinkModel cloneForSource(NodeModel sourceClone, String targetId) {
        return new ConnectorModel(sourceClone, targetId, this.connectorProperties);
    }

    @Override
    public NodeLinkModel cloneForSource(NodeModel sourceClone) {
        NodeRelativePath clonePath;
        NodeRelativePath pathAncestorToSource;
        NodeModel ancestorClone;
        NodeRelativePath nodeRelativePath;
        NodeModel commonAncestor;
        NodeModel source = this.getSource();
        if (sourceClone == source) {
            return this;
        }
        if (sourceClone.getMap().getNodeForID(source.getID()) == null) {
            return null;
        }
        NodeModel target = this.getTarget();
        if (target != null && target.getParentNode() != null && (commonAncestor = (nodeRelativePath = new NodeRelativePath(source, target)).commonAncestor()).isSubtreeCloneOf(ancestorClone = nodeRelativePath.ancestorForBegin(sourceClone)) && (pathAncestorToSource = new NodeRelativePath(commonAncestor, source)).equalPathsTo(clonePath = new NodeRelativePath(ancestorClone, sourceClone))) {
            NodeModel targetClone = nodeRelativePath.pathEnd(ancestorClone);
            String targetID = targetClone.createID();
            return this.cloneForSource(sourceClone, targetID);
        }
        return null;
    }
}

