/*******************************************************************************
 * Copyright 2021 Intel Corporation.
 *
 * This software and the related documents are Intel copyrighted  materials,  and
 * your use of  them is  governed by the  express license  under which  they were
 * provided to you (License).  Unless the License provides otherwise, you may not
 * use, modify, copy, publish, distribute,  disclose or transmit this software or
 * the related documents without Intel's prior written permission.
 *
 * This software and the related documents  are provided as  is,  with no express
 * or implied  warranties,  other  than those  that are  expressly stated  in the
 * License.
 *******************************************************************************/

/*
//   Description:
//       Intel(R) Integrated Performance Primitives (Intel(R) IPP) FilterSeparable Functions Wrappers for Threading Layer redefinitions:
//       functions with _L API call their _LT versions
//
//   Content:
//       ippiFilterSeparableInit_16s_LT_Proxy
//       ippiFilterSeparableInit_32f_LT_Proxy
//       ippiFilterSeparable_8u_C1R_LT_Proxy
//       ippiFilterSeparable_8u_C3R_LT_Proxy
//       ippiFilterSeparable_8u_C4R_LT_Proxy
//       ippiFilterSeparable_16s_C1R_LT_Proxy
//       ippiFilterSeparable_16s_C3R_LT_Proxy
//       ippiFilterSeparable_16s_C4R_LT_Proxy
//       ippiFilterSeparable_16u_C1R_LT_Proxy
//       ippiFilterSeparable_16u_C3R_LT_Proxy
//       ippiFilterSeparable_16u_C4R_LT_Proxy
//       ippiFilterSeparable_32f_C1R_LT_Proxy
//       ippiFilterSeparable_32f_C3R_LT_Proxy
//       ippiFilterSeparable_32f_C4R_LT_Proxy
//       ippiFilterSeparable_8u16s_C1R_LT_Proxy
//       ippiFilterSeparable_8u16s_C3R_LT_Proxy
//       ippiFilterSeparable_8u16s_C4R_LT_Proxy
//
*/

#if defined(IPP_ENABLED_THREADING_LAYER_REDEFINITIONS)
  #error \
      "This file is not intended to be compiled with -DIPP_ENABLED_THREADING_LAYER_REDEFINITIONS option. Use this option in your application instead."
#endif

#include "owndefs_tl.h"
#include "ippcv_tl.h"

/* //////////////////////////////////////////////////////////// */

#define ippiFilterSeparable_LT_Proxy(srcType, dstType, depth, chan, borderValueType)                                              \
    IPPFUN(IppStatus, ippiFilterSeparable_##depth##_C##chan##R_LT_Proxy,                                                          \
           (const srcType *pSrc, IppSizeL srcStep, dstType *pDst, IppSizeL dstStep, IppiSizeL roiSize, IpprBorderType borderType, \
            borderValueType borderValue, const IppiFilterSeparableSpec *pSpec, Ipp8u *pBuffer))                                   \
    {                                                                                                                             \
        return ippiFilterSeparable_##depth##_C##chan##R_LT(pSrc, srcStep, pDst, dstStep, roiSize, borderType, borderValue,        \
                                                           (IppiFilterSeparableSpec_LT *)pSpec, pBuffer);                         \
    }

ippiFilterSeparable_LT_Proxy(Ipp8u, Ipp8u, 8u, 1, Ipp8u);
ippiFilterSeparable_LT_Proxy(Ipp8u, Ipp8u, 8u, 3, Ipp8u *);
ippiFilterSeparable_LT_Proxy(Ipp8u, Ipp8u, 8u, 4, Ipp8u *);
ippiFilterSeparable_LT_Proxy(Ipp8u, Ipp16s, 8u16s, 1, Ipp8u);
ippiFilterSeparable_LT_Proxy(Ipp8u, Ipp16s, 8u16s, 3, Ipp8u *);
ippiFilterSeparable_LT_Proxy(Ipp8u, Ipp16s, 8u16s, 4, Ipp8u *);
ippiFilterSeparable_LT_Proxy(Ipp16s, Ipp16s, 16s, 1, Ipp16s);
ippiFilterSeparable_LT_Proxy(Ipp16s, Ipp16s, 16s, 3, Ipp16s *);
ippiFilterSeparable_LT_Proxy(Ipp16s, Ipp16s, 16s, 4, Ipp16s *);
ippiFilterSeparable_LT_Proxy(Ipp16u, Ipp16u, 16u, 1, Ipp16u);
ippiFilterSeparable_LT_Proxy(Ipp16u, Ipp16u, 16u, 3, Ipp16u *);
ippiFilterSeparable_LT_Proxy(Ipp16u, Ipp16u, 16u, 4, Ipp16u *);
ippiFilterSeparable_LT_Proxy(Ipp32f, Ipp32f, 32f, 1, Ipp32f);
ippiFilterSeparable_LT_Proxy(Ipp32f, Ipp32f, 32f, 3, Ipp32f *);
ippiFilterSeparable_LT_Proxy(Ipp32f, Ipp32f, 32f, 4, Ipp32f *);

IPPFUN(IppStatus, ippiFilterSeparableInit_16s_LT_Proxy,
       (const Ipp16s *pRowKernel, const Ipp16s *pColumnKernel, IppiSize kernelSize, int divisor, int scaleFactor, IppDataType dataType,
        int numChannels, IppiFilterSeparableSpec *pSpec))
{
    return ippiFilterSeparableInit_16s_LT(pRowKernel, pColumnKernel, kernelSize, divisor, scaleFactor, dataType, numChannels,
                                          (IppiFilterSeparableSpec_LT *)pSpec);
}

IPPFUN(IppStatus, ippiFilterSeparableInit_32f_LT_Proxy,
       (const Ipp32f *pRowKernel, const Ipp32f *pColumnKernel, IppiSize kernelSize, IppDataType dataType, int numChannels,
        IppiFilterSeparableSpec *pSpec))
{
    return ippiFilterSeparableInit_32f_LT(pRowKernel, pColumnKernel, kernelSize, dataType, numChannels, (IppiFilterSeparableSpec_LT *)pSpec);
}

/* //////////////////////////////////////////////////////////// */
