/*******************************************************************************
 * Copyright 2005 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *******************************************************************************/

#define VIDEO_WINMAIN_ARGS

#include <stdio.h>
#include <iostream>

#include "ipp_blur_rotate.h"
#include "ipp_blur_rotate_video.h"

const char *filename = "./data/Image.bmp";

int main(int argc, char *argv[])
{
    try {
        ipp_blur_rotate_video video;
        ipp_blur_rotate iBlurRotate;

        if (iBlurRotate.loadFileBMP(filename)) {
            IppiSize winSize = iBlurRotate.windowSize();
            // video layer init
            if (video.init_window(winSize.width, winSize.height)) {
                video.calc_fps = false;
                video.threaded = 1;
                // initialize ////////////
                video.set_object(iBlurRotate);
                // main loop
                video.main_loop();
            } else {
                std::cerr << "Cannot initialize video layer\n";
            }
        } else {
            std::cerr << "Cannot load the file: " << filename << "\n";
        }

        video.terminate();
    } catch (std::exception &e) {
        std::cerr << "error occurred. error text is :\"" << e.what() << "\"\n";

        return 1;
    }

    return 0;
}
