#!/usr/bin/env python
import argparse
import os
import subprocess
import sys
try:
 import advisor
except ImportError:
 err_msg="""
    Python could not resolve path to Advisor\'s Python API directory. To fix, either manually add path
    to the Python API directory into PYTHONPATH environment variable, or use advixe-vars.* scripts to
    set up product environment variables automatically.
    """
 raise ImportError(err_msg)
def extract_data(proj_dir):
 project=advisor.open_project(proj_dir)
 survey=project.load(advisor.SURVEY)
 with open(args.out,'wb')as f:
  f.write('digraph G {\n')
  for row in survey.bottomup:
   print('type: {}, location: {}'.format(row['type'],row['source_location']))
   print('function_call_sites_and_loops: {}'.format(row['function_call_sites_and_loops']))
   print('\tloop_function_id: {}, parent_id: {}'.format(row['loop_function_id'],row['parent_id']))
   f.write('{} -> {}\n'.format(row['parent_id'],row['loop_function_id']))
   f.write('{} [label="{}\\n id:{}\\n{}@{}"]\n'.format(row['loop_function_id'],row['type'],row['loop_function_id'],row['function_call_sites_and_loops'],row['source_location']))
  f.write('}\n')
def main():
 global args
 parser=argparse.ArgumentParser()
 parser.add_argument("-v","--verbose",dest="verbose",help="output verbosity",action="store_true",default=False)
 parser.add_argument("project_dir",help="path to advisor project dir")
 parser.add_argument("-o",dest="out",help="Results output file. default: graph.dot")
 args=parser.parse_args()
 sanity_checks(args)
 extract_data(args.project_dir)
def sanity_checks(in_args):
 if not in_args.out:
  in_args.out="graph.dot"
if __name__=='__main__':
 main()
