from apm_helpers.convert import get_size_unit
from apm_helpers.messages import Messages as help_msg
from debug import myprint
def limit_string(s,n):
 if n>0 and len(s)>n:
  return s[:n-3]+'...'
 else:
  return s
class Formatter:
 def __init__(self,title,value,width,postfix):
  self._title=title
  self._val=value
  self._shown_val=value
  self._width=width
  self._postfix=postfix
 def get_title(self):
  title_format="{{:{}s}}".format(self._width)
  return title_format.format(self._title)
 def get_value(self):
  return self._val
 def gen_format(self):
  pass
 def __str__(self):
  return limit_string(self.gen_format().format(self._shown_val),self._width)
 @classmethod
 def suit(cls,col)->bool:
  return False
class StrFormatter(Formatter):
 def __init__(self,title,value,width,postfix):
  super().__init__(title,value,width,postfix)
 def gen_format(self):
  if self._width>0:
   return "{{:{}s}}{}".format(self._width-len(self._postfix),self._postfix)
  return "{{:s}}{}".format(self._postfix)
 @classmethod
 def suit(cls,col)->bool:
  return col.get('filter',"string")!="number" and 'format' not in col
class IntFormatter(Formatter):
 def gen_format(self):
  if self._width>0:
   return "{{:{}d}}{}".format(self._width-len(self._postfix),self._postfix)
  return "{{:d}}{}".format(self._postfix)
 @classmethod
 def suit(cls,col)->bool:
  return 'format' in col and col['format']['type']=='uint'
class FloatFormatter(Formatter):
 format_types={'f':'f','e':'e','s':'f'}
 def __init__(self,title,value,width,postfix,digits,format_type):
  super().__init__(title,value,width,postfix)
  self._format_type=FloatFormatter.format_types[format_type]
  self._digits=digits
 def gen_format(self):
  if self._width>0:
   return "{{:{}.{}{}}}{}".format(self._width-len(self._postfix),self._digits,self._format_type,self._postfix)
  return "{{:.{}{}}}{}".format(self._digits,self._format_type,self._postfix)
 @classmethod
 def suit(cls,col)->bool:
  return 'format' in col and col['format']['type']in FloatFormatter.format_types
class DataSizeFormatter(Formatter):
 units=['B','KB','MB','GB','TB']
 base=1000
 def __init__(self,title,value,width,digits):
  super().__init__(title,value,width,"")
  self._digits=digits
  self._shown_val,self._postfix=get_size_unit(value,DataSizeFormatter.units,DataSizeFormatter.base)
 def gen_format(self):
  if self._width>0:
   return "{{:{}.{}f}}{}".format(self._width-len(self._postfix),self._digits,self._postfix)
  return "{{:.{}f}}{}".format(self._digits,self._postfix)
 @classmethod
 def suit(cls,col)->bool:
  return 'format' in col and col['format']['type']=='dm'
class MultiFormatter(Formatter):
 def __init__(self,title,value,width,template,formatters:list):
  super().__init__(title,value,width,'')
  self._formatters=formatters
  self._template=template
 def __str__(self):
  _formatters_str=[str(f)for f in self._formatters]
  return limit_string(self._template.format(*_formatters_str),self._width)
 @classmethod
 def suit(cls,col)->bool:
  return 'format' in col and col['format']['type']=='c'
def generate_formatter(row,target_metric,width,col):
 title=col['title']
 postfix=col.get('postfix','')
 row_width=max(width,len(title))
 value=row[target_metric]
 formatter=gen_single_formatter(col,title,value,row_width,postfix)
 if formatter:
  return formatter
 if MultiFormatter.suit(col):
  formatters=[gen_single_formatter(child_col,child_col['key'],row[child_col['key']],-1,child_col.get('postfix',''))for child_col in col['format']['custom_format']['columns']]
  if None in formatters:
   myprint(help_msg.ERROR_COLUMN_FORMAT.format(col.get('key',title)),severity=4)
  return MultiFormatter(title,value,row_width,col['format']['custom_format']['template'],formatters)
 return myprint(help_msg.ERROR_COLUMN_FORMAT.format(col.get('key',title)),severity=4)
def gen_single_formatter(col,title,value,row_width,postfix):
 if StrFormatter.suit(col):
  return StrFormatter(title,value,row_width,postfix)
 if IntFormatter.suit(col):
  return IntFormatter(title,value,row_width,postfix)
 if FloatFormatter.suit(col):
  return FloatFormatter(title,value,row_width,postfix,col['format']['digits'],col['format']['type'])
 if DataSizeFormatter.suit(col):
  return DataSizeFormatter(title,value,row_width,col['format']['digits'])
 return None
