/*
 * Copyright (C) 2020 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

__kernel void LocalAdd(__local float *pa, __local float *pb, __local float *pc, __local float *pd,
    __local float *pe, __local float *pf, __local float *pg, __local float *ph, __local float *pi)
{
    const int id = get_local_id(0);

    for (int count = 0; count < 128; count++)
    {
        pc[id] = pa[id] + pb[id];
        pd[id] = pe[id] + pf[id];
        pg[id] = ph[id] + pi[id];
    }
}
