/*******************************************************************************
* Copyright (C) 2005 Intel Corporation
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
 *
 * dfftw_plan_dft_c2r - FFTW3 Fortran 77 wrapper to Intel(R) oneAPI Math Kernel Library (Intel(R) oneMKL).
 *
 ******************************************************************************
 */

#include "fftw3_mkl_f77.h"
#ifdef DFT_ENABLE_OFFLOAD
#include "oneapi/mkl/export.hpp"
#include "fftw3_omp_offload_common.h"

DLL_EXPORT void
dfftw_plan_dft_c2r_omp_offload(PLAN *p, INTEGER *rank, INTEGER *n, CFI_cdesc_t *in,
              CFI_cdesc_t *out, INTEGER *flags, void *interopObj)
{
    dfftw_plan_dft_c2r_omp_offload_impl(p, rank, n, (COMPLEX16 *)in->base_addr,
                          (REAL8 *)out->base_addr, flags, interopObj);
}

DLL_EXPORT void
dfftw_plan_dft_c2r_cpu(PLAN *p, INTEGER *rank, INTEGER *n, CFI_cdesc_t *in,
                   CFI_cdesc_t *out, INTEGER *flags)
{
    dfftw_plan_dft_c2r(p, rank, n, (COMPLEX16 *)in->base_addr,
                   (REAL8 *)out->base_addr, flags);
}

void
dfftw_plan_dft_c2r_omp_offload_impl(PLAN *p, INTEGER *rank, INTEGER *n, COMPLEX16 *in,
               REAL8 *out, INTEGER *flags, void *interopObj)
#else
void
dfftw_plan_dft_c2r(PLAN *p, INTEGER *rank, INTEGER *n, COMPLEX16 *in,
                   REAL8 *out, INTEGER *flags)
#endif
{
    fftw_iodim64 dims64[MKL_MAXRANK];
    int i, inplace;

    if (p == NULL || rank == NULL || n == NULL)
        return;

    *(MKL_INT64 *)p = 0;
    if (*rank > MKL_MAXRANK)
        return;

    inplace = ((void *)in == (void *)out);

    for (i = 0; i < *rank; ++i)
        dims64[*rank - i - 1].n = n[i];

    /* compute strides, different for inplace and out-of-place */
    inplace = ((void *)in == (void *)out);
    if (*rank > 0)
    {
        dims64[*rank - 1].is = 1;
        dims64[*rank - 1].os = 1;
    }
    if (*rank > 1)
    {
        dims64[*rank - 2].is = dims64[*rank - 1].n / 2 + 1;
        dims64[*rank - 2].os =
            (inplace ? dims64[*rank - 2].is * 2 : dims64[*rank - 1].n);
    }
    for (i = *rank - 2; i > 0; --i)
    {
        dims64[i - 1].is = dims64[i].is * dims64[i].n;
        dims64[i - 1].os = dims64[i].os * dims64[i].n;
    }
#ifdef DFT_ENABLE_OFFLOAD
    if (mkl_dfti_is_ilp64 == 1)
        *(fftw_plan *)p = fftw_plan_guru64_dft_c2r_omp_offload_impl_ilp64(
            *rank, dims64, 0, NULL, in, out, *flags, interopObj);
    else
        *(fftw_plan *)p = fftw_plan_guru64_dft_c2r_omp_offload_impl_lp64(
            *rank, dims64, 0, NULL, in, out, *flags, interopObj);
#else
    *(fftw_plan *)p =
        fftw_plan_guru64_dft_c2r(*rank, dims64, 0, NULL, in, out, *flags);
#endif
}
