"use strict";angular.module("sourcepane",["ui-session","grid","services","loading","searchDialog","splitter","ngRoute"],["$routeProvider",i=>{i.when("/sourceview/:identity",{template:'<div class="sourcepane" localize="localize" default-msg-catalog="sourceviewapi1"><div class="toolbar"><div class="grids-switch-panel" data-tour-item="sourceAssemblyPanelTourItem"><button ng-click="toggleView(modes.SOURCE_GRID)" class="ui button source" ng-class="{ active: sourceGridVisible, disabled: !isAvailableSourceGrid() || sourceGridLoading.isInProgress()}" data-tour-item="sourceButtonTourItem">{{::localize(\'%SourceButtonLabel\')}}</button> <button ng-click="toggleView(modes.ASSEMBLY_GRID)" class="ui button assembly" ng-class="{ active: assemblyGridVisible, disabled: !isAvailableAssemblyGrid() || assemblyGridLoading.isInProgress()}" data-tour-item="assemblyButtonTourItem">{{::localize(\'%AssemblyButtonLabel\')}}</button></div><div class="view-mode-panel"><div class="ui icon buttons"><button class="ui basic button" ng-attr-tooltip="{{::localize(\'%VerticalModeTooltip\')}}" ng-class="{ active: !isViewModesDisabled() && !isVerticalLayoutMode, disabled: isViewModesDisabled()}" ng-click="isVerticalLayoutMode = false"><i class="icon layout-vertical solid"></i></button> <button class="ui basic button" ng-attr-tooltip="{{::localize(\'%HorizontalModeTooltip\')}}" ng-class="{ active: !isViewModesDisabled() && isVerticalLayoutMode, disabled: isViewModesDisabled()}" ng-click="isVerticalLayoutMode = true"><i class="icon layout-horizontal solid"></i></button></div></div><div class="navigation-panel" data-tour-item="hotspotsSourceNavigationPanelTourItem"><button ng-repeat="navigationAction in navigationActions" class="ui icon basic button" ng-attr-id="{{::navigationAction.action}}" ng-attr-tooltip="{{::localize(navigationAction.tooltip)}}" ng-click="navigateHotspot(navigationAction.action)" ng-disabled="isLastActiveViewNotReady()"><i class="icon" ng-class="navigationAction.icon"></i></button></div><div class="assembly-grouping-selector" ng-show="assemblyGridVisible"><span class="label">{{::localize(\'%AssemblyGrouping\')}}</span> <select ng-model="assemblyGridGrouping" ng-options="grouping as grouping.displayName for grouping in assemblyGridGroupings" ng-disabled="assemblyGridLoading.isInProgress() || !assemblyGridHasData()"></select></div><button class="ui icon basic button source-search" ng-attr-tooltip="{{::localize(\'%SearchTooltip\')}}" ng-click="showSearchDialog()" ng-disabled="isLastActiveViewNotReady()" data-tour-item="findSourceTourItem"><i class="icon magnifier-o"></i></button></div><div class="grid-area"><div class="source-grid-area" ng-attr-id="{{::modes.SOURCE_GRID + paneId}}"><src-grid actions="sourceGridActions" adjacent-grid-visible="assemblyGridVisible" file="sourceFileName" has-data="sourceGridHasData" hotspots-navigation-column="sourceGridNavigationColumn" is-visible="sourceGridVisible" last-active-view="lastActiveView" loading="sourceGridLoading" on-show-search="showSourceSearch" pane-id="paneId" process-row-selection="assemblyGridReload" reload="sourceGridReload" switch-to-adjacent-grid="switchGrid" type="modes.SOURCE_GRID" , file-path="::sourceFilePath"></src-grid></div><splitter add-sash="false" idvc-splitter="idvcSplitter" is-vertical="isVerticalLayoutMode" ng-attr-primary-div="{{::modes.SOURCE_GRID + paneId}}" ng-attr-secondary-div="{{::modes.ASSEMBLY_GRID + paneId}}" size="50%"></splitter><div class="assembly-grid-area" ng-attr-id="{{::modes.ASSEMBLY_GRID + paneId}}"><src-grid actions="assemblyGridActions" adjacent-grid-visible="sourceGridVisible" file="binaryFileName" grouping="assemblyGridGrouping" has-data="assemblyGridHasData" hotspots-navigation-column="assemblyGridNavigationColumn" is-default-grid="isAssemblyGridDefault" is-visible="assemblyGridVisible" last-active-view="lastActiveView" loading="assemblyGridLoading" on-show-search="showAssemblySearch" pane-id="paneId" process-row-selection="sourceGridReload" reload="assemblyGridReload" switch-to-adjacent-grid="switchGrid" type="modes.ASSEMBLY_GRID" instruction-reference-available="instructionReferenceAvailable" file-path="::binaryFilePath"></src-grid></div></div><div class="no-data icon warning" ng-show="mode === modes.UNKNOWN" html-content="{{::localize(\'%ErrorText\')}}"></div><loading show-when="sourcePaneLoading.isInProgress()"></loading></div><sourceview-test-harness-dump pane-id="paneId" results="results" pane-type="sourceview"></sourceview-test-harness-dump>',controller:"SourcePaneController"})}]);
"use strict";angular.module("sourcepane").directive("sourcePane",(function(){return{restrict:"E",scope:{paneId:"=",targetFilterKey:"=",dataFilterKey:"=",diveGrouping:"="},template:'<div class="sourcepane" localize="localize" default-msg-catalog="sourceviewapi1"><div class="toolbar"><div class="grids-switch-panel" data-tour-item="sourceAssemblyPanelTourItem"><button ng-click="toggleView(modes.SOURCE_GRID)" class="ui button source" ng-class="{ active: sourceGridVisible, disabled: !isAvailableSourceGrid() || sourceGridLoading.isInProgress()}" data-tour-item="sourceButtonTourItem">{{::localize(\'%SourceButtonLabel\')}}</button> <button ng-click="toggleView(modes.ASSEMBLY_GRID)" class="ui button assembly" ng-class="{ active: assemblyGridVisible, disabled: !isAvailableAssemblyGrid() || assemblyGridLoading.isInProgress()}" data-tour-item="assemblyButtonTourItem">{{::localize(\'%AssemblyButtonLabel\')}}</button></div><div class="view-mode-panel"><div class="ui icon buttons"><button class="ui basic button" ng-attr-tooltip="{{::localize(\'%VerticalModeTooltip\')}}" ng-class="{ active: !isViewModesDisabled() && !isVerticalLayoutMode, disabled: isViewModesDisabled()}" ng-click="isVerticalLayoutMode = false"><i class="icon layout-vertical solid"></i></button> <button class="ui basic button" ng-attr-tooltip="{{::localize(\'%HorizontalModeTooltip\')}}" ng-class="{ active: !isViewModesDisabled() && isVerticalLayoutMode, disabled: isViewModesDisabled()}" ng-click="isVerticalLayoutMode = true"><i class="icon layout-horizontal solid"></i></button></div></div><div class="navigation-panel" data-tour-item="hotspotsSourceNavigationPanelTourItem"><button ng-repeat="navigationAction in navigationActions" class="ui icon basic button" ng-attr-id="{{::navigationAction.action}}" ng-attr-tooltip="{{::localize(navigationAction.tooltip)}}" ng-click="navigateHotspot(navigationAction.action)" ng-disabled="isLastActiveViewNotReady()"><i class="icon" ng-class="navigationAction.icon"></i></button></div><div class="assembly-grouping-selector" ng-show="assemblyGridVisible"><span class="label">{{::localize(\'%AssemblyGrouping\')}}</span> <select ng-model="assemblyGridGrouping" ng-options="grouping as grouping.displayName for grouping in assemblyGridGroupings" ng-disabled="assemblyGridLoading.isInProgress() || !assemblyGridHasData()"></select></div><button class="ui icon basic button source-search" ng-attr-tooltip="{{::localize(\'%SearchTooltip\')}}" ng-click="showSearchDialog()" ng-disabled="isLastActiveViewNotReady()" data-tour-item="findSourceTourItem"><i class="icon magnifier-o"></i></button></div><div class="grid-area"><div class="source-grid-area" ng-attr-id="{{::modes.SOURCE_GRID + paneId}}"><src-grid actions="sourceGridActions" adjacent-grid-visible="assemblyGridVisible" file="sourceFileName" has-data="sourceGridHasData" hotspots-navigation-column="sourceGridNavigationColumn" is-visible="sourceGridVisible" last-active-view="lastActiveView" loading="sourceGridLoading" on-show-search="showSourceSearch" pane-id="paneId" process-row-selection="assemblyGridReload" reload="sourceGridReload" switch-to-adjacent-grid="switchGrid" type="modes.SOURCE_GRID" , file-path="::sourceFilePath"></src-grid></div><splitter add-sash="false" idvc-splitter="idvcSplitter" is-vertical="isVerticalLayoutMode" ng-attr-primary-div="{{::modes.SOURCE_GRID + paneId}}" ng-attr-secondary-div="{{::modes.ASSEMBLY_GRID + paneId}}" size="50%"></splitter><div class="assembly-grid-area" ng-attr-id="{{::modes.ASSEMBLY_GRID + paneId}}"><src-grid actions="assemblyGridActions" adjacent-grid-visible="sourceGridVisible" file="binaryFileName" grouping="assemblyGridGrouping" has-data="assemblyGridHasData" hotspots-navigation-column="assemblyGridNavigationColumn" is-default-grid="isAssemblyGridDefault" is-visible="assemblyGridVisible" last-active-view="lastActiveView" loading="assemblyGridLoading" on-show-search="showAssemblySearch" pane-id="paneId" process-row-selection="sourceGridReload" reload="assemblyGridReload" switch-to-adjacent-grid="switchGrid" type="modes.ASSEMBLY_GRID" instruction-reference-available="instructionReferenceAvailable" file-path="::binaryFilePath"></src-grid></div></div><div class="no-data icon warning" ng-show="mode === modes.UNKNOWN" html-content="{{::localize(\'%ErrorText\')}}"></div><loading show-when="sourcePaneLoading.isInProgress()"></loading></div><sourceview-test-harness-dump pane-id="paneId" results="results" pane-type="sourceview"></sourceview-test-harness-dump>',controller:"SourcePaneController"}}));
"use strict";angular.module("sourcepane").controller("SourcePaneController",["$scope","requestIdentity","$http","$q","uiSession","error","Tracker","sourcepaneConstants","helpTour",function(e,i,t,o,r,s,a,n,l){e.isVerticalLayoutMode=!1,e.modes=n.sourceGridModes,e.navigationActions=[{action:"max",tooltip:"%GoToMaxTooltip",icon:"hotspot-biggest"},{action:"next",tooltip:"%GoToNextTooltip",icon:"hotspot-bigger"},{action:"previous",tooltip:"%GoToPreviousTooltip",icon:"hotspot-smaller"},{action:"min",tooltip:"%GoToMinTooltip",icon:"hotspot-smallest"}];const d=o.defer();function u(){e.mode===e.modes.SOURCE_GRID?(e.sourceGridVisible=!0,e.idvcSplitter&&e.idvcSplitter.foldSecondary()):(e.assemblyGridVisible=!0,e.idvcSplitter&&e.idvcSplitter.foldPrimary())}e.paneId=e.paneId||i.get(e),e.sourcePaneLoading=new a,e.sourcePaneLoading.start(),r.getPartitionSocket(e).then((()=>{function o(i){i.groupings&&(e.assemblyGridGroupings=i.groupings,e.assemblyGridGrouping=e.assemblyGridGroupings[0])}t.post("api/sourceview/initializePane",{},{params:{identity:i.get(e),paneId:e.paneId,targetFilterKey:e.targetFilterKey,dataFilterKey:e.dataFilterKey,diveGrouping:e.diveGrouping,requestGroup:e.paneId},timeout:d.promise}).then((a=>{a.error||t.get("api/sourceview/fileInfo",{params:{identity:i.get(e),paneId:e.paneId,requestGroup:e.paneId}}).then(s.validateResponse).then((i=>{!function(i){let t="Unknown";e.mode=i.mode,i.mode===e.modes.SOURCE_GRID?(t=i.sourceFileName,e.sourceFileName=i.sourceFileName,e.binaryFileName=i.binaryFileName,e.sourceFilePath=i.sourceFilePath,e.binaryFilePath=i.binaryFilePath):i.mode===e.modes.ASSEMBLY_GRID&&(t=i.binaryFileName,e.binaryFileName=i.binaryFileName,e.binaryFilePath=i.binaryFilePath);e.$emit("TabCaptionUpdated",{caption:t,paneId:e.paneId,tooltip:e.sourceFilePath}),r.getPartitionSocket(e).then((e=>{e.emit("TabCaptionUpdated",{caption:t,icon:i.mode})}))}(i),e.instructionReferenceAvailable=i.instructionReferenceAvailable})).then((()=>{if(e.mode&&e.mode!==e.modes.UNKNOWN){if(e.isAvailableAssemblyGrid())return t.get("api/sourceview/groupings",{params:{identity:i.get(e),queryType:e.modes.ASSEMBLY_GRID,paneId:e.paneId,requestGroup:e.paneId},timeout:d.promise}).then(s.validateResponse).then(o).then(u);u()}})).finally(e.sourcePaneLoading.stop)}))})),e.isAssemblyGridDefault=function(){return!(e.isAvailableSourceGrid()&&e.sourceGridHasData())},e.isAvailableAssemblyGrid=function(){return e.binaryFileName&&e.binaryFileName.length},e.isAvailableSourceGrid=function(){return e.sourceFileName&&e.sourceFileName.length},e.isLastActiveViewNotReady=function(){if(!e.lastActiveView)return!0;if(e.lastActiveView===e.modes.SOURCE_GRID){if(e.sourceGridLoading.isInProgress()||!e.sourceGridHasData())return!0}else if(e.assemblyGridLoading.isInProgress()||!e.assemblyGridHasData())return!0;return!1},e.isViewModesDisabled=function(){return!(e.isAvailableSourceGrid()&&e.isAvailableAssemblyGrid()&&e.sourceGridVisible&&e.assemblyGridVisible)},e.navigateHotspot=function(o){const{lastActiveView:r}=e;r&&function(o){return t.get("api/sourceview/navigate",{params:{identity:i.get(e),paneId:e.paneId,queryType:e.lastActiveView,navigationType:o,requestGroup:e.paneId}})}(o).then(s.validateResponse).then((i=>{if(i.navigationResult&&r){let t;r===e.modes.SOURCE_GRID?t=e.sourceGridActions:r===e.modes.ASSEMBLY_GRID&&(t=e.assemblyGridActions);const o=i.navigationResult.index;t.bringRowToView&&t.setCurrentRow&&void 0!==o&&(t.bringRowToView(o),t.setCurrentRow(o))}}))},e.showSearchDialog=function(){e.lastActiveView&&(e.lastActiveView===e.modes.SOURCE_GRID?e.showSourceSearch:e.showAssemblySearch)()},e.switchGrid=function(i){if(i===e.modes.SOURCE_GRID){if(!e.isAvailableAssemblyGrid())return;e.sourceGridVisible=!1,e.assemblyGridVisible=!0,e.idvcSplitter.foldPrimary()}else{if(!e.isAvailableSourceGrid())return;e.sourceGridVisible=!0,e.assemblyGridVisible=!1,e.idvcSplitter.foldSecondary()}},e.toggleView=function(i){if(i===e.modes.SOURCE_GRID){if(!e.isAvailableAssemblyGrid()||!e.assemblyGridVisible)return;e.sourceGridVisible=!e.sourceGridVisible,e.sourceGridVisible?e.idvcSplitter.unfold():e.idvcSplitter.foldPrimary()}else{if(!e.isAvailableSourceGrid()||!e.sourceGridVisible)return;e.assemblyGridVisible=!e.assemblyGridVisible,e.assemblyGridVisible?e.idvcSplitter.unfold():e.idvcSplitter.foldSecondary()}},l.setTourStepActions("gettingStarted","assemblyButtonTourItem",{activatePane(){e.toggleView(n.sourceGridModes.ASSEMBLY_GRID)}}),e.$on("$destroy",(()=>{t.post("api/sourceview/closePane",{},{params:{identity:i.get(e),paneId:e.paneId,requestGroup:e.paneId},timeout:d.promise})}))}]);
"use strict";angular.module("sourcepane").factory("sourcepaneConstants",(function(){return{fileLocationChangeRequestTimeout:200,sourceGridModes:{SOURCE_GRID:"source",ASSEMBLY_GRID:"assembly",UNKNOWN:"unknown"}}}));
"use strict";angular.module("sourcepane").controller("FileLocatorController",["$scope","requestIdentity","uiSession","$http","error","sourcepaneConstants","fileDialog","productMode",function(e,i,t,o,r,a,n,s){let l;e.fileLocation="",e.addPathToProjectDirs=!0,e.modes=a.sourceGridModes,e.isBrowserMode=s.isBrowserMode(),t.getPartitionSocket(e).then((()=>{o.get("api/sourceview/getFileSearchResults",{params:{identity:i.get(e),queryType:e.type,paneId:e.paneId}}).then((i=>{const t=i.data.suggestResults;if(t&&t.length){e.fileSuggestions=t;const i=t.find((e=>"error"!==e.severity));i&&(e.fileLocation=i.filePath,i.errorMessage&&(e.validationError={message:i.errorMessage,severity:i.severity}),e.onFileChange())}}))})),e.browse=function(){n.showOpenDialog({dialogType:"open",defaultFileName:e.fileLocation,defaultPath:e.fileLocation}).then((function(i){i&&i&&(e.fileLocation=i,e.onFileChange())}))},e.getErrorIcon=function(){if(e.validationError)return"unknown"===e.validationError.severity?"":e.validationError.severity},e.isSourceMode=function(){return e.type===a.sourceGridModes.SOURCE_GRID},e.onClose=function(){e.adjacentGridVisible&&e.switchGrid?e.switchGrid(e.type):e.$emit("result:close-source-tab",{paneId:e.paneId})},e.onFileChange=function(){l&&clearTimeout(l),e.fileLocation&&(l=setTimeout((()=>{o.get("api/sourceview/validateFile",{params:{identity:i.get(e),queryType:e.type,fileName:e.fileLocation,paneId:e.paneId}}).then(r.validateResponse).then((i=>{const{searchDirs:t,defaultSearchDir:o,fileValidationResult:r,fileName:a}=i;a&&(e.sourceFileName=a),t&&t.length&&(e.fileSearchDirs=t),o&&(e.searchDir=o.dir),"unknown"!==r.severity?e.validationError={message:r.errorMessage,severity:r.severity}:delete e.validationError}))}),a.fileLocationChangeRequestTimeout))},e.passedValidation=function(){return!(e.validationError&&"error"===e.validationError.severity)},e.submit=function(){if(e.$emit("TabCaptionUpdated",{caption:e.sourceFileName,paneId:e.paneId,tooltip:e.fileLocation}),!e.refreshGrid)return;const i={forced:!0,fileLocation:e.fileLocation};e.addPathToProjectDirs&&(i.addedPath=e.searchDir),e.refreshGrid(i)}}]);
"use strict";angular.module("sourcepane").directive("fileLocator",(function(){return{restrict:"E",scope:{adjacentGridVisible:"=",file:"=",filePath:"<",refreshGrid:"=",switchGrid:"=?",type:"=",paneId:"="},template:'<h3 class="ui header" localize="localize">{{::localize(isSourceMode() ? \'%FileLocatorHeaderSource\' : \'%FileLocatorHeaderAssembly\')}}</h3><div class="form-container" localize="localize"><div class="ui form"><div class="ui field" ng-attr-tooltip="{{::filePath}}"><input ng-model="filePath" ng-disabled="true"></div><div class="ui field location"><label>{{ ::localize(\'%SpecifyLocationLabel\') }}</label><div class="ui action input size-watch"><input type="text" ng-model="fileLocation" ng-change="onFileChange()"><div class="ui icon left dropdown button" ng-model="fileLocation" ng-change="onFileChange()"><i class="ui dropdown icon"></i><div class="left menu"><div class="item" ng-repeat="file in fileSuggestions" ng-attr-data-value="{{::file.filePath}}">{{::file.filePath}}</div></div></div><button class="ui icon button" ng-click="browse()" ng-if="::!isBrowserMode"><i class="icon folder-open"></i></button></div></div><div class="validation-message icon" ng-class="getErrorIcon()" ng-if="validationError">{{validationError.message}}</div><div class="fields"><div class="ui field" ng-class="{ disabled: !fileLocation || !passedValidation()}"><div class="ui checkbox"><input type="checkbox" ng-model="addPathToProjectDirs"> <label>{{ ::localize(\'%AddPathAsLabel\') }}</label></div></div><div class="ui field" ng-class="{ disabled: !fileLocation || !passedValidation() || !addPathToProjectDirs }"><div class="ui action input size-watch"><input type="text" ng-model="searchDir" ng-disabled="!fileLocation"><div class="ui icon left dropdown button" ng-model="searchDir"><i class="ui dropdown icon"></i><div class="left menu"><div class="item" ng-repeat="searchDir in fileSearchDirs" data-value="{{searchDir.dir}}">{{searchDir.dir}}</div></div></div></div></div></div><div class="ui field"><button class="ui button" ng-disabled="!fileLocation || !passedValidation()" ng-click="submit()">{{ ::localize(\'%SubmitLabel\') }}</button> <button class="ui button" ng-show="type === modes.SOURCE_GRID && !adjacentGridVisible" ng-click="switchGrid(type)">{{ ::localize(\'%ShowAssemblyLabel\') }}</button> <button class="ui button" ng-click="onClose()">{{ ::localize(\'%CloseLabel\') }}</button></div></div></div>',controller:"FileLocatorController"}}));
"use strict";angular.module("sourcepane").controller("SrcGridController",["$scope","$http","$timeout","requestIdentity","sourcepaneConstants","localize","globalConstants","error","color","Tracker","clipboard","productHelp",function(e,t,o,n,i,a,s,r,c,l,u,p){let g,d=!1;let f,h;e.fileNotFound=!1,e.gridDomain="sourceview",e.isVisible=!1,e.loading=new l,e.modes=i.sourceGridModes,e.noData=!1,e.notifications=[],e.searchData={showSearchDialog:!1};const w=e.$watch("grouping",(function(){e.grouping&&e.isVisible&&e.init()})),R=e.$watch("isVisible",(function(){e.isVisible?e.gridData?d&&e.actions.reload&&(e.actions.reload(),d=!1):e.init():e.lastActiveView===e.type&&(e.lastActiveView=void 0)})),m=e.$watch("lastActiveView",(function(){void 0===e.lastActiveView&&!e.adjacentGridVisible&&e.isVisible&&e.actions.setFocus&&e.actions.setFocus()}));function v(){return t.get("api/sourceview/getHighlightInfo",{params:I({maxBinCount:500})}).then(r.validateResponse).then((t=>{e.highlightBins=t.nonEmptyBins,f=t.binCount}))}function C(){t.get("api/sourceview/getHotspotInfo",{params:I({maxBinCount:500})}).then(r.validateResponse).then((t=>{e.hotspotBins=t.nonEmptyBins,h=t.binCount})),v()}function y(e,t){return(e.binIndex+.5)/t*100+"%"}function I(t){const o={identity:n.get(e),paneId:e.paneId,queryType:e.type,requestGroup:e.paneId};return t&&Object.assign(o,t),o}function b(e){return t.get("api/sourceview/getInstructionReference",{params:I({rowIndex:e})}).then(r.validateResponse).then((e=>{e.errorMessage?D(e.errorMessage,s.notificationTypes.ERROR,s.notificationTimeout):e.path&&void 0!==e.page&&p.openAssemblyInstructionReference(e).then((e=>{e.errorMessage&&D(e.errorMessage,s.notificationTypes.ERROR,s.notificationTimeout)}))}))}function D(t,n,i){const a={message:t,type:n};e.notifications.push(a),i&&o((()=>{e.onNotificationClose(a)}),i)}e.$on("$destroy",(function(){w&&w(),R&&R(),m&&m()})),e.actions={onCellDblClick:t=>{t<0||!e.instructionReferenceAvailable||b(t)},onCollapseAll:C,onExpandRow:C,onExpandSelectedRows:C,onSortColumn:C,processSetFocus:()=>{e.lastActiveView=e.type}},e.contextMenuOptions={gridType:e.type,instructionReferenceAvailable:()=>e.instructionReferenceAvailable,isApplicableForHotspotsNavigation:()=>{if(!e.actions.getContextMenuInfo)return;const t=e.actions.getContextMenuInfo();return t?t.contextMenuItem.col!==e.hotspotsNavigationColumn&&t.columnInfo.isData:void 0},openInstructionReference:()=>{const t=e.actions.getContextMenuInfo();t&&b(t.contextMenuItem.row)},setColumnAsHotspotsNavigationColumn:()=>{const o=e.actions.getContextMenuInfo();o&&(g&&delete g.isHotspotsNavigationColumn,g=o.columnInfo,g.isHotspotsNavigationColumn=!0,e.actions.refreshColumns&&e.actions.refreshColumns([e.hotspotsNavigationColumn,o.contextMenuItem.col]),t.post("api/sourceview/setNavigationColumn",{},{params:{identity:n.get(e),paneId:e.paneId,queryType:e.type,navigationColumn:e.hotspotsNavigationColumn,requestGroup:e.paneId}}).then(r.validateResponse).then(C))},copyFilePath:()=>{u.copy(e.filePath)}},e.getHighlightMarkStyle=e=>({top:y(e,f),height:100/f+"%"}),e.getHotspotMarkStyle=e=>({top:y(e,h),opacity:.3+.7*e.hotspotWeight,background:c.toRgba(g.color)}),e.gotoMark=function(t){if(t.target.className.indexOf("hotspot navigation mark")>=0){const o=parseInt(t.target.dataset.rowIndex);e.actions.bringRowToView(o),e.actions.setCurrentRow(o)}else{const o=t.clientY-$(t.target).offset().top,n=Math.ceil(e.actions.getRowCount()*o/t.target.clientHeight);e.actions.bringRowToView(n)}t.stopPropagation(),t.preventDefault()},e.hasData=function(){return!(e.noData||e.fileNotFound)},e.init=function(t){e.fileNotFound=!1,e.noData=!1;const i={paneId:e.paneId,identity:n.get(e),queryType:e.type,requestGroup:e.paneId,filter:"global"};e.grouping&&(i.grouping=e.grouping.query),t&&Object.assign(i,t),e.gridData=i,o((()=>e.actions.setStorageState({})))},e.onFileError=()=>{a("%FailedToSaveFileLabel").then((e=>D(e,s.notificationTypes.ERROR,s.notificationTimeout)))},e.onNotificationClose=t=>{e.notifications.splice(e.notifications.indexOf(t),1)},e.onRowSelected=t=>{t&&e.processRowSelection&&(e.processRowSelection(t),delete e.highlightBins)},e.onShowSearch=function(){e.noData||e.fileNotFound||(e.searchData.showSearchDialog=!e.searchData.showSearchDialog)},e.persistState=function(){},e.processDefaultSelection=function(t){return t&&t.initialSelectionRowCandidate&&(t.view.currentRow=t.initialSelectionRowCandidate.index,t.view.scrollToCurrent=!0,(e.type===e.modes.SOURCE_GRID||e.type===e.modes.ASSEMBLY_GRID&&e.isDefaultGrid())&&(t.view.selectCurrent=!0)),!0},e.processMetadata=function(t){if(delete this.gridData.forced,delete this.gridData.addedPath,delete this.gridData.fileLocation,e.fileNotFound=!(!t.searchFileResult||!t.searchFileResult.fileNotFound),!e.fileNotFound&&t.columns&&t.rows){const e=t.columns.find((e=>e.isData));e&&(e.isHotspotsNavigationColumn=!0,g=e,C()),t.warningMessage&&D(t.warningMessage.message,s.notificationTypes.WARNING)}return e.fileNotFound},e.reload=function(){e.isVisible&&e.hasData()&&e.actions.reload?(e.actions.reload(),v().then((()=>{if(e.highlightBins&&e.highlightBins.length>0){const[{rowIndex:t}]=e.highlightBins;e.actions.bringRowToView(t)}}))):e.hasData()&&(d=!0)},this.gotoHyperlink=function(o){const n=e.actions.getBufferSize();return t.post("api/sourceview/followHyperLink",{row:parseInt(o)},{params:I()}).then(r.validateResponse).then((function(t){const o=t.hyperLinkDestination;o&&o.index>=0&&(void 0===t.rowIndexForScrollRequest?e.actions.bringRowToView(o.index):e.actions.update("scroll",{row:t.rowIndexForScrollRequest,count:n},(e=>{e.view.scrollToCurrent=!0,e.view.currentRow=o.index,e.view.forceUpdate=!0})),e.actions.setCurrentRow(o.index))}))}}]);
"use strict";angular.module("sourcepane").directive("srcGrid",(function(){return{restrict:"E",scope:{actions:"=?",adjacentGridVisible:"=",file:"=",grouping:"=",hasData:"=?",hotspotsNavigationColumn:"=",isDefaultGrid:"=?",isVisible:"=",lastActiveView:"=",loading:"=",onShowSearch:"=?",paneId:"=",processRowSelection:"=?",reload:"=?",switchToAdjacentGrid:"=?",type:"=",filePath:"<?",instructionReferenceAvailable:"<?"},template:'<div ng-if="file && file.length" ng-class="{idvc_disable: loading.isInProgress()}" ng-keydown="actions.keyDown($event)" ng-keyup="actions.keyUp($event)" ng-show="isVisible" localize="localize"><div class="source-grid-container" ng-hide="noData || fileNotFound"><div class="grid-container"><grid actions="actions" central-column-width="70%" context-menu-options="contextMenuOptions" file-error-callback="onFileError" grid-data="gridData" grid-domain="gridDomain" loading="loading" messages="{}" no-data="noData" number-of-pinned-columns="type === modes.SOURCE_GRID ? 2 : 3" on-search="onSearch" persist-state="persistState" process-metadata="processMetadata" process-default-selection="processDefaultSelection" row-selection-callback="onRowSelected" search-data="searchData" view-source="viewSource"></grid></div><div class="navigation-info-container" data-stopRefreshSize="true" ng-click="gotoMark($event)"><div ng-repeat="bin in highlightBins" class="highlight navigation mark" ng-style="getHighlightMarkStyle(bin)" ng-attr-data-row-index="{{bin.rowIndex}}"></div><div ng-repeat="bin in hotspotBins" class="hotspot navigation mark" ng-style="getHotspotMarkStyle(bin)" ng-attr-data-row-index="{{bin.rowIndex}}"></div></div></div><div class="no-data" ng-show="noData">{{::localize(\'%NoDataMsgTitle\')}}</div><loading show-when="loading.isInProgress()"></loading><file-locator ng-if="fileNotFound" adjacent-grid-visible="adjacentGridVisible" data-stopRefreshSize="true" file="file" file-path="filePath" refresh-grid="init" switch-grid="switchToAdjacentGrid" type="type" pane-id="paneId"></file-locator><search-dialog on-search="onSearch" search-data="searchData"></search-dialog><notification ng-repeat="notification in notifications" type="notification.type" message="notification.message" on-close="onNotificationClose(notification)"></notification></div>',controller:"SrcGridController",link:function(i,e,t,n){i.actions.addCellHTMLContent=function(i,e,t,n){if(e.isHyperLink&&"assemblyContent"===t.columnType){let t="src-grid-hyperlink";return e.isHyperLinkDisabled&&(t+=" disabled"),`<a class="${t}" data-row-id="${n}">${i}</a>`}return i},i.actions.getCellStyle=function(i,e){const t=[];return i.isNotTarget&&t.push("shaded"),i.isBasicBlock&&t.push("basic-block"),!i.isMarker||"sourceContent"!==e.columnType&&"assemblyContent"!==e.columnType||t.push("marker"),t.join(" ")},i.actions.getColumnLayout=function(i){if(i&&i.isHotspotsNavigationColumn)return{column:{className:"hotspots_navigation_column"}}},i.actions.getColumnPrefix=function(e,t){if(e.isHotspotsNavigationColumn)return i.hotspotsNavigationColumn=t,'<span class="icon hotspot"></span>'},i.actions.onCellMouseDown=function(i){i.target.className.indexOf("src-grid-hyperlink")>=0&&(i.stopPropagation(),i.preventDefault(),n.gotoHyperlink(i.target.dataset.rowId))}}}}));
"use strict";angular.module("sourcepane").directive("sourceviewTestHarnessDump",["$timeout","$q","$interval","dumpDispatcher",function(e,t,n,i){return{restrict:"E",scope:{paneId:"=",results:"=",gridActions:"=",srcGridHasData:"=",asmGridHasData:"=",paneType:"@"},link:function(s){const a="sourceview";function o(t,i,s,a){const o=n((()=>{a()&&(i.resolve(),n.cancel(o),e.cancel(r))}),s),r=e((function(){n.cancel(o),i.reject("Timeout on waiting for "+t)}),6e4)}function r(e,t,n){return`/test-harness/action?type=${t}&view=${e}&param=${n}&paneId=${a}`}i.addDumpListener({paneId:a,$scope:s},(async function(e){const n=".sourcepane .grid-area .assembly-grid-area",i=".sourcepane .grid-area .source-grid-area",s="assembly"===e.view?n:i;try{if("getGridData"===e.command){await function(e){const n=t.defer();return o("loading of "+e+" to complete",n,500,(()=>$(e+" .idvcgrid_cell").length>0)),n.promise}(s);const e={paneId:a,dump:{}},n=function(e){const t=[],n=$(e+" .idvcgrid_body"),i=n.find(".idvcgrid_column").map((function(){const e=0!==$(this).find(".idvcgrid_column_sorting").length,n=$($(this).find(".idvcgrid_header_section .idvcgrid_header_section_text")[0]).text();let i="none";e&&(i=0===$(this).find(".idvcgrid_sorting_backward").length?"backward":"forward");let s=t[t.length-1];for(;s&&s.offset>=this.offsetTop;)t.pop(),s=t[t.length-1];return t.push({name:n,offset:this.offsetTop}),{sorted:e,sortOrder:i,expanded:$(this).hasClass("idvcgrid_inactive_column"),value:n,uniqueValue:t.map((e=>e.name)).join(":"),expandable:!!$(this).find(".idvcgrid_expand_collapse_column").length}})).get();return i}(s);e.dump.columns=n;const i=await async function(e){const t=function(e){const t=e+" .idvcgrid_central_column",n=document.querySelector(t);if(n)return n.idvcVTGridObject}(e),n=[];let i=-1;function s(e){return e=(e=e.replace(/\u2196 /g,"")).replace(/\u2190/g,"<-")}return await t.enumCells(((e,a,o)=>{i<0&&(i=a);const r=a-i;let c,d=e.innerText;o===t.centralColumnIndex&&(d=s(d));const l={value:d};if(n.length<=r?c={data:[l]}:(c=n[r],c.data.push(l)),o===t.centralColumnIndex){const t=Number($(e).find(".idvcgrid_widget.idvcgrid_expand_collapse").attr("data-hierarchical-level")),n={id:a,selected:$(e).hasClass("idvcgrid_selected_row"),level:t,expanded:0===$(e).find(".idvcgrid_collapsed").length};Object.assign(c,n)}if(n.length<r){const e=n.length;n.length=r,n.fill({data:[]},e)}n.length===r&&n.push(c)})),n}(s);return n.forEach(((e,t)=>{e.expanded&&i.forEach((e=>{e.data.splice(t,0,{value:""})}))})),e.dump.rows=function(e){if(!e.length)return[];const t=[e[0]],n=[e[0]];let[i]=e,s=i.level;for(let a=1;a<e.length;++a){const o=e[a],{level:r}=o;if(0===r&&t.push(o),r>s)i.rows||(i.rows=[]),i.rows.push(o),i=o,s=r,n.push(i);else if(r<=s){for(;0!==n.length;){if(i=n[n.length-1],i.level<r){i.rows||(i.rows=[]),i.rows.push(o);break}n.pop()}i=o,s=r,n.push(o)}}return t}(i),e}if("waitForView"===e.command)return await function(){const e=t.defer();return o("sourcepane is visible",e,500,(()=>$(".sourcepane .toolbar").is(":visible")&&!$(".sourcepane .loading.control").is(":visible"))),e.promise}(),{paneId:a,dump:{source:{isVisible:$(i).is(":visible"),showHide:r("source","showHide"),navigateMax:r("source","navigateHotspot","max"),navigateMin:r("source","navigateHotspot","min"),navigateNext:r("source","navigateHotspot","next"),navigatePrevious:r("source","navigateHotspot","previous")},assembly:{isVisible:$(n).is(":visible"),showHide:r("assembly","showHide"),navigateMax:r("assembly","navigateHotspot","max"),navigateMin:r("assembly","navigateHotspot","min"),navigateNext:r("assembly","navigateHotspot","next"),navigatePrevious:r("assembly","navigateHotspot","previous")}}}}catch(e){return{paneId:a,dump:{message:e.message||e,stack:e.stack}}}})),i.addActionListener({paneId:a,$scope:s},(async function(n){const i=$(".sourcepane .toolbar");let s;if("showHide"===n.type)s=i.find("assembly"===n.view?".assembly":".source");else if("navigateHotspot"===n.type){s=i.find(`#${n.param}`);$(`src-grid[type="modes.${"assembly"===n.view?"ASSEMBLY":"SOURCE"}_GRID"] grid`).scope().actions.setFocus()}try{return function(n){const i=t.defer();return e((()=>{n.click(),i.resolve()})),i.promise}(s)}catch(e){console.warn(e)}}))}}}]);
//# sourceMappingURL=sourcepane-630424.js.map
