/*
 * Copyright (C) 2005 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

#ifndef _CORE2_H_
#define _CORE2_H_

#include "msrdefs.h"

extern DISPATCH_NODE  corei7_dispatch;
extern DISPATCH_NODE  corei7_dispatch_htoff_mode;

#if defined(DRV_IA32)
#define LBR_DATA_BITS                  32
#else
#define LBR_DATA_BITS                  48
#endif

#define LBR_BITMASK                    ((1ULL << LBR_DATA_BITS) -1)

typedef struct SADDR_S {
    S64 addr:LBR_DATA_BITS;
} SADDR;

#define SADDR_addr(x)                  (x).addr

#endif
