/* This testcase is part of GDB, the GNU debugger.

   Copyright 2021-2025 Free Software Foundation, Inc.
   Copyright (C) 2021-2025 Intel Corporation

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#include <unistd.h>
#include <pthread.h>

void *
forever ()
{
  /* Wait for alarm.  */
  while (1)
    sleep (1); /* break here  */
}

int
main ()
{
  alarm (30);

  pthread_t forever_thread;
  pthread_create (&forever_thread, NULL, *forever, NULL);
  pthread_join (forever_thread, NULL);

  return 0;
}
