# Copyright (C) 2021-2025 Free Software Foundation, Inc.
# Copyright (C) 2021-2025 Intel Corporation

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from perftest import perftest

class Sycl_FalseCondBP(perftest.TestCaseWithBasicMeasurements):
    def __init__(self, bp_last_line, device_type):
        test_name = "Sycl_FalseCondBP-" + device_type
        super(Sycl_FalseCondBP, self).__init__(test_name)
        self.bp_last_line = str(bp_last_line)
        self.bp = None

    def warm_up(self):
        """Set breakpoint inside kernel."""
        self.bp = gdb.Breakpoint(self.bp_last_line)

    def _do_continue_to_bp(self):
        """Run the command and wait for the output."""
        gdb.execute("continue")

    def execute_test(self):
        self.bp.condition = "false"
        self.measure.measure(lambda: self._do_continue_to_bp(), 1)
