/*******************************************************************************
 * Copyright 2005 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *******************************************************************************/

/* Intel(R) Integrated Performance Primitives (Intel(R) IPP) tutorial */

#ifndef IPP_BLUR_ROTATE_VIDEO_H__
#define IPP_BLUR_ROTATE_VIDEO_H__

#include "ipp_blur_rotate.h"

extern video *v;

/*
// Time operations
*/
#ifdef _WIN32
void time_sleep(unsigned int msec)
{
    if (msec)
        Sleep(msec);
}

#else
  #include <sched.h>

void time_sleep(unsigned int msec)
{
    if (msec)
        usleep(1000 * msec);
    else
        sched_yield();
}
#endif

class ipp_blur_rotate_video : public video
{
    ipp_blur_rotate *ibr;

private:
    void on_key(int key)
    {
        if (ibr) {
            ibr->onKey(key);
        }
    }

    void on_process()
    {
        if (ibr) {
            while (v->running) {
                ibr->process(get_drawing_memory());
                video::next_frame();
#ifndef _WIN32
                time_sleep(10);
#endif
            }
        }
    }

public:
    ipp_blur_rotate_video() : ibr(0)
    {
        title = "Intel(R) IPP: blur + rotate tutorial";
        v = this;
    }

    void set_object(ipp_blur_rotate &_ibr) { ibr = &_ibr; }
};

#endif /* IPP_BLUR_ROTATE_VIDEO_H__ */
