#
# Copyright (C) 2021 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of them
# is governed by the express license under which they were provided to you ("License"). Unless
# the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
# or transmit this software or the related documents without Intel's prior written permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#


# ------------------------------------------------------------------------------
# This example shows how to get categories for rows in the topdown.
# ------------------------------------------------------------------------------

import sys

try:

    import advisor

except ImportError:

    print(
        """Import error: Python could not resolve path to Advisor's pythonapi directory.
        To fix, either manually add path to the pythonapi directory into PYTHONPATH environment
        variable, or use advixe-vars.* scripts to set up product environment variables automatically."""
    )
    sys.exit(1)

# Check command-line arguments.
if len(sys.argv) < 2:
    print('Usage: "python {} path_to_project_dir"'.format(__file__))
    sys.exit(2)

# Open the Advisor Project and load the data.
project = advisor.open_project(sys.argv[1])
data = project.load(advisor.SURVEY)

name_key = "function_call_sites_and_loops"
key_len = len(name_key)

# Traverse the topdown tree and determine the max length of name fields.
# also take into account depth to show it with indentation.
for row in data.topdown:
    stack = [(row, 0)]
    while stack:
        v, level = stack.pop()
        for r in v.get_children():
            stack.append((r, level + 1))
        key_len = max(key_len, len(v[name_key]) + level * 2)

# Prepare formats with enough space to show all fields.
fmt = "{:<" + str(max(key_len, 32)) + "} {:<}"

# Traverse topdown tree again and pretty-print categories for each row.
print(fmt.format(*([name_key, 'categories'])))
for row in data.topdown:
    stack = [(row, 0)]
    while stack:
        v, level = stack.pop()
        for r in v.get_children():
            stack.append((r, level + 1))
        print(fmt.format(" " * level * 2 + v[name_key], ','.join(v.categories)))
