/*
    Copyright (C) 2021 Intel Corporation.  All Rights Reserved.

    This file is part of SEP Development Kit.

    SEP Development Kit is free software; you can redistribute it
    and/or modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

    SEP Development Kit is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SEP Development Kit; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    As a special exception, you may use this file as part of a free software
    library without restriction.  Specifically, if other files instantiate
    templates or use macros or inline functions from this file, or you compile
    this file and link it with other files to produce an executable, this
    file does not by itself cause the resulting executable to be covered by
    the GNU General Public License.  This exception does not however
    invalidate any other reasons why the executable file might be covered by
    the GNU General Public License.
*/

#include "modcfg.h"
#include "pcb.h"
#include "regs.h"

/* processor control block */
DEFINE_PER_CPU_SHARED_ALIGNED(struct vtss_pcb, vtss_pcb_var);

int vtss_pcb_init(void)
{
	int cpu;

	for (cpu = 0; cpu < vtss_nr_cpus(); cpu++)
		memset(&vtss_pcb(cpu), 0, sizeof(struct vtss_pcb));
	return 0;
}
