/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.util.ClassUtils;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.javasupport.proxy.ReifiedJavaProxy;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.RubyStringBuilder;

public class JavaMethod
extends JavaCallable {
    private final Method method;
    private final Class<?> boxedReturnType;
    private final boolean isFinal;
    private final JavaUtil.JavaConverter returnConverter;

    public final Method getValue() {
        return this.method;
    }

    public JavaMethod(Ruby runtime2, Method method2) {
        super(method2.getParameterTypes());
        this.method = method2;
        this.isFinal = Modifier.isFinal(method2.getModifiers());
        Class<?> returnType = method2.getReturnType();
        this.boxedReturnType = returnType.isPrimitive() && returnType != Void.TYPE ? CodegenUtils.getBoxType(returnType) : returnType;
        if (RubyInstanceConfig.SET_ACCESSIBLE) {
            try {
                if (Modifier.isPublic(method2.getModifiers()) && !Modifier.isPublic(method2.getDeclaringClass().getModifiers())) {
                    Java.trySetAccessible(method2);
                }
            }
            catch (SecurityException se) {
                Warn.warn(runtime2.getCurrentContext(), "failed to setAccessible: " + String.valueOf(method2) + ", exception follows: " + se.getMessage());
            }
        }
        this.returnConverter = JavaUtil.getJavaConverter(returnType);
    }

    public static JavaMethod create(Ruby runtime2, Method method2) {
        return new JavaMethod(runtime2, method2);
    }

    @Deprecated
    public static JavaMethod create(Ruby runtime2, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        try {
            return JavaMethod.create(runtime2, javaClass.getMethod(methodName, argumentTypes));
        }
        catch (NoSuchMethodException e) {
            throw Error.nameError(runtime2.getCurrentContext(), RubyModule.undefinedMethodMessage(runtime2, RubyStringBuilder.ids(runtime2, methodName), RubyStringBuilder.ids(runtime2, javaClass.getName()), false), methodName);
        }
    }

    @Deprecated
    public static JavaMethod createDeclared(Ruby runtime2, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        try {
            return JavaMethod.create(runtime2, javaClass.getDeclaredMethod(methodName, argumentTypes));
        }
        catch (NoSuchMethodException e) {
            throw Error.nameError(runtime2.getCurrentContext(), RubyModule.undefinedMethodMessage(runtime2, RubyStringBuilder.ids(runtime2, methodName), RubyStringBuilder.ids(runtime2, javaClass.getName()), false), methodName);
        }
    }

    public static JavaMethod getMatchingDeclaredMethod(Ruby runtime2, Class<?> javaClass, String methodName, Class<?>[] argumentTypes) {
        Method m = ClassUtils.getMatchingDeclaredMethod(javaClass, methodName, argumentTypes);
        if (m == null) {
            return null;
        }
        return new JavaMethod(runtime2, m);
    }

    @Override
    public final boolean equals(Object other) {
        return other instanceof JavaMethod && this.method.equals(((JavaMethod)other).method);
    }

    @Override
    public final int hashCode() {
        return this.method.hashCode();
    }

    public IRubyObject invokeDirect(ThreadContext context, Object javaInvokee, Object[] args2) {
        this.checkArity(context, args2.length);
        this.checkInstanceof(context, javaInvokee);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(context, javaInvokee, args2);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, args2);
    }

    public IRubyObject invokeDirect(ThreadContext context, Object javaInvokee) {
        assert (this.method.getDeclaringClass().isInstance(javaInvokee));
        this.checkArity(context, 0);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(context, javaInvokee);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee);
    }

    public IRubyObject invokeDirect(ThreadContext context, Object javaInvokee, Object arg0) {
        assert (this.method.getDeclaringClass().isInstance(javaInvokee));
        this.checkArity(context, 1);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(context, javaInvokee, arg0);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0);
    }

    public IRubyObject invokeDirect(ThreadContext context, Object javaInvokee, Object arg0, Object arg1) {
        assert (this.method.getDeclaringClass().isInstance(javaInvokee));
        this.checkArity(context, 2);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(context, javaInvokee, arg0, arg1);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0, arg1);
    }

    public IRubyObject invokeDirect(ThreadContext context, Object javaInvokee, Object arg0, Object arg1, Object arg2) {
        assert (this.method.getDeclaringClass().isInstance(javaInvokee));
        this.checkArity(context, 3);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(context, javaInvokee, arg0, arg1, arg2);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0, arg1, arg2);
    }

    public IRubyObject invokeDirect(ThreadContext context, Object javaInvokee, Object arg0, Object arg1, Object arg2, Object arg3) {
        assert (this.method.getDeclaringClass().isInstance(javaInvokee));
        this.checkArity(context, 4);
        if (this.mightBeProxy(javaInvokee)) {
            return this.tryProxyInvocation(context, javaInvokee, arg0, arg1, arg2, arg3);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0, arg1, arg2, arg3);
    }

    public IRubyObject invokeStaticDirect(ThreadContext context, Object[] args2) {
        this.checkArity(context, args2.length);
        return this.invokeDirectWithExceptionHandling(context, this.method, (Object)null, args2);
    }

    public IRubyObject invokeStaticDirect(ThreadContext context) {
        this.checkArity(context, 0);
        return this.invokeDirectWithExceptionHandling(context, this.method, null);
    }

    public IRubyObject invokeStaticDirect(ThreadContext context, Object arg0) {
        this.checkArity(context, 1);
        return this.invokeDirectWithExceptionHandling(context, this.method, null, arg0);
    }

    public IRubyObject invokeStaticDirect(ThreadContext context, Object arg0, Object arg1) {
        this.checkArity(context, 2);
        return this.invokeDirectWithExceptionHandling(context, this.method, null, arg0, arg1);
    }

    public IRubyObject invokeStaticDirect(ThreadContext context, Object arg0, Object arg1, Object arg2) {
        this.checkArity(context, 3);
        return this.invokeDirectWithExceptionHandling(context, this.method, null, arg0, arg1, arg2);
    }

    public IRubyObject invokeStaticDirect(ThreadContext context, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.checkArity(context, 4);
        return this.invokeDirectWithExceptionHandling(context, this.method, null, arg0, arg1, arg2, arg3);
    }

    private void checkInstanceof(ThreadContext context, Object javaInvokee) throws RaiseException {
        if (!this.method.getDeclaringClass().isInstance(javaInvokee)) {
            throw Error.typeError(context, "invokee not instance of method's class (got" + javaInvokee.getClass().getName() + " wanted " + this.method.getDeclaringClass().getName() + ")");
        }
    }

    private IRubyObject invokeWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee, Object[] arguments) {
        try {
            Object result2 = method2.invoke(javaInvokee, arguments);
            return this.returnConverter.convert(context.runtime, result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, method2, arguments);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    public IRubyObject invokeDirectSuperWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee, Object ... arguments) {
        try {
            Object result2 = method2.invoke(javaInvokee, arguments);
            return this.convertReturn(context.runtime, result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, method2, arguments);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    public IRubyObject invokeDirectWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee, Object[] arguments) {
        try {
            Object result2 = method2.invoke(javaInvokee, arguments);
            return this.convertReturn(context.runtime, result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, method2, arguments);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee) {
        try {
            Object result2 = method2.invoke(javaInvokee, new Object[0]);
            return this.convertReturn(context.runtime, result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, method2, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee, Object arg0) {
        try {
            Object result2 = method2.invoke(javaInvokee, arg0);
            return this.convertReturn(context.runtime, result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, method2, arg0);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee, Object arg0, Object arg1) {
        try {
            Object result2 = method2.invoke(javaInvokee, arg0, arg1);
            return this.convertReturn(context.runtime, result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, method2, arg0, arg1);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee, Object arg0, Object arg1, Object arg2) {
        try {
            Object result2 = method2.invoke(javaInvokee, arg0, arg1, arg2);
            return this.convertReturn(context.runtime, result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, method2, arg0, arg1, arg2);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    private IRubyObject invokeDirectWithExceptionHandling(ThreadContext context, Method method2, Object javaInvokee, Object arg0, Object arg1, Object arg2, Object arg3) {
        try {
            Object result2 = method2.invoke(javaInvokee, arg0, arg1, arg2, arg3);
            return this.convertReturn(context.runtime, result2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(context, iae, method2, arg0, arg1, arg2, arg3);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(context, iae, method2);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(context, ite);
        }
        catch (Throwable t) {
            return this.handleThrowable(context, t);
        }
    }

    private IRubyObject convertReturn(Ruby runtime2, Object result2) {
        if (result2 != null && result2.getClass() != this.boxedReturnType) {
            return JavaUtil.convertJavaToUsableRubyObject(runtime2, result2);
        }
        return JavaUtil.convertJavaToUsableRubyObjectWithConverter(runtime2, result2, this.returnConverter);
    }

    public String getName() {
        return this.method.getName();
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.method.getExceptionTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    @Override
    public Type[] getGenericExceptionTypes() {
        return this.method.getGenericExceptionTypes();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.method.getParameterAnnotations();
    }

    @Override
    public final boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    @Override
    public final int getModifiers() {
        return this.method.getModifiers();
    }

    @Override
    public String toGenericString() {
        return this.method.toGenericString();
    }

    @Override
    public final AccessibleObject accessibleObject() {
        return this.method;
    }

    private boolean mightBeProxy(Object javaInvokee) {
        return javaInvokee instanceof ReifiedJavaProxy && !this.isFinal;
    }

    private IRubyObject tryProxyInvocation(ThreadContext context, Object javaInvokee, Object ... args2) {
        JavaProxyClass jpc = ((ReifiedJavaProxy)javaInvokee).___jruby$proxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(context, jpm.getSuperMethod(), javaInvokee, args2);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, args2);
    }

    private IRubyObject tryProxyInvocation(ThreadContext context, Object javaInvokee) {
        JavaProxyClass jpc = ((ReifiedJavaProxy)javaInvokee).___jruby$proxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(context, jpm.getSuperMethod(), javaInvokee, new Object[0]);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee);
    }

    private IRubyObject tryProxyInvocation(ThreadContext context, Object javaInvokee, Object arg0) {
        JavaProxyClass jpc = ((ReifiedJavaProxy)javaInvokee).___jruby$proxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(context, jpm.getSuperMethod(), javaInvokee, arg0);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0);
    }

    private IRubyObject tryProxyInvocation(ThreadContext context, Object javaInvokee, Object arg0, Object arg1) {
        JavaProxyClass jpc = ((ReifiedJavaProxy)javaInvokee).___jruby$proxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(context, jpm.getSuperMethod(), javaInvokee, arg0, arg1);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0, arg1);
    }

    private IRubyObject tryProxyInvocation(ThreadContext context, Object javaInvokee, Object arg0, Object arg1, Object arg2) {
        JavaProxyClass jpc = ((ReifiedJavaProxy)javaInvokee).___jruby$proxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(context, jpm.getSuperMethod(), javaInvokee, arg0, arg1, arg2);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0, arg1, arg2);
    }

    private IRubyObject tryProxyInvocation(ThreadContext context, Object javaInvokee, Object arg0, Object arg1, Object arg2, Object arg3) {
        JavaProxyClass jpc = ((ReifiedJavaProxy)javaInvokee).___jruby$proxyClass();
        JavaProxyMethod jpm = jpc.getMethod(this.method.getName(), this.parameterTypes);
        if (jpm != null && jpm.hasSuperImplementation()) {
            return this.invokeDirectSuperWithExceptionHandling(context, jpm.getSuperMethod(), javaInvokee, arg0, arg1, arg2, arg3);
        }
        return this.invokeDirectWithExceptionHandling(context, this.method, javaInvokee, arg0, arg1, arg2, arg3);
    }

    @Deprecated(since="10.0")
    public static RaiseException newMethodNotFoundError(Ruby runtime2, Class target2, String prettyName, String simpleName) {
        return JavaMethod.newMethodNotFoundError(runtime2.getCurrentContext(), target2, prettyName, simpleName);
    }

    public static RaiseException newMethodNotFoundError(ThreadContext context, Class target2, String prettyName, String simpleName) {
        return Error.nameError(context, "java method not found: " + target2.getName() + "." + prettyName, simpleName);
    }

    public static RaiseException newArgSizeMismatchError(Ruby runtime2, Class ... argTypes) {
        return Error.argumentError(runtime2.getCurrentContext(), "argument count mismatch for method signature " + String.valueOf(CodegenUtils.prettyParams(argTypes)));
    }
}

