/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage.serialization;

import java.util.Optional;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.log.remote.metadata.storage.generated.RemoteLogSegmentMetadataUpdateRecord;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogMetadataTransform;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;

public class RemoteLogSegmentMetadataUpdateTransform
implements RemoteLogMetadataTransform<RemoteLogSegmentMetadataUpdate> {
    @Override
    public ApiMessageAndVersion toApiMessageAndVersion(RemoteLogSegmentMetadataUpdate segmentMetadataUpdate) {
        RemoteLogSegmentMetadataUpdateRecord record = new RemoteLogSegmentMetadataUpdateRecord().setRemoteLogSegmentId(this.createRemoteLogSegmentIdEntry(segmentMetadataUpdate)).setBrokerId(segmentMetadataUpdate.brokerId()).setEventTimestampMs(segmentMetadataUpdate.eventTimestampMs()).setRemoteLogSegmentState(segmentMetadataUpdate.state().id());
        segmentMetadataUpdate.customMetadata().ifPresent(md -> record.setCustomMetadata(md.value()));
        return new ApiMessageAndVersion((ApiMessage)record, record.highestSupportedVersion());
    }

    @Override
    public RemoteLogSegmentMetadataUpdate fromApiMessageAndVersion(ApiMessageAndVersion apiMessageAndVersion) {
        RemoteLogSegmentMetadataUpdateRecord record = (RemoteLogSegmentMetadataUpdateRecord)apiMessageAndVersion.message();
        RemoteLogSegmentMetadataUpdateRecord.RemoteLogSegmentIdEntry entry = record.remoteLogSegmentId();
        TopicIdPartition topicIdPartition = new TopicIdPartition(entry.topicIdPartition().id(), new TopicPartition(entry.topicIdPartition().name(), entry.topicIdPartition().partition()));
        Optional<RemoteLogSegmentMetadata.CustomMetadata> customMetadata = Optional.ofNullable(record.customMetadata()).map(RemoteLogSegmentMetadata.CustomMetadata::new);
        return new RemoteLogSegmentMetadataUpdate(new RemoteLogSegmentId(topicIdPartition, entry.id()), record.eventTimestampMs(), customMetadata, RemoteLogSegmentState.forId((byte)record.remoteLogSegmentState()), record.brokerId());
    }

    private RemoteLogSegmentMetadataUpdateRecord.RemoteLogSegmentIdEntry createRemoteLogSegmentIdEntry(RemoteLogSegmentMetadataUpdate data) {
        return new RemoteLogSegmentMetadataUpdateRecord.RemoteLogSegmentIdEntry().setId(data.remoteLogSegmentId().id()).setTopicIdPartition(new RemoteLogSegmentMetadataUpdateRecord.TopicIdPartitionEntry().setName(data.remoteLogSegmentId().topicIdPartition().topic()).setPartition(data.remoteLogSegmentId().topicIdPartition().partition()).setId(data.remoteLogSegmentId().topicIdPartition().topicId()));
    }
}

