/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.io.Serializable;
import org.hibernate.annotations.Nationalized;
import org.keycloak.models.jpa.entities.RealmEntity;

@NamedQueries(value={@NamedQuery(name="deleteRealmAttributesByRealm", query="delete from RealmAttributeEntity attr where attr.realm = :realm"), @NamedQuery(name="selectRealmAttributesNotEmptyByName", query="select ra from RealmAttributeEntity ra WHERE ra.name = :name and length(ra.value) > 0")})
@Table(name="REALM_ATTRIBUTE")
@Entity
@IdClass(value=Key.class)
public class RealmAttributeEntity {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="REALM_ID")
    protected RealmEntity realm;
    @Id
    @Column(name="NAME")
    protected String name;
    @Nationalized
    @Column(name="VALUE")
    protected String value;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public RealmEntity getRealm() {
        return this.realm;
    }

    public void setRealm(RealmEntity realm) {
        this.realm = realm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof RealmAttributeEntity)) {
            return false;
        }
        RealmAttributeEntity key = (RealmAttributeEntity)o;
        if (this.name != null ? !this.name.equals(key.name) : key.name != null) {
            return false;
        }
        return !(this.realm != null ? !this.realm.getId().equals(key.realm != null ? key.realm.getId() : null) : key.realm != null);
    }

    public int hashCode() {
        int result = this.realm != null ? this.realm.getId().hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public static class Key
    implements Serializable {
        protected RealmEntity realm;
        protected String name;

        public Key() {
        }

        public Key(RealmEntity user, String name) {
            this.realm = user;
            this.name = name;
        }

        public RealmEntity getRealm() {
            return this.realm;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.name != null ? !this.name.equals(key.name) : key.name != null) {
                return false;
            }
            return !(this.realm != null ? !this.realm.getId().equals(key.realm != null ? key.realm.getId() : null) : key.realm != null);
        }

        public int hashCode() {
            int result = this.realm != null ? this.realm.getId().hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}

