/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime.filter;

import io.quarkus.runtime.rest.DisabledRestEndpoints;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;

public class DisabledRestEndpointsFilter
implements OASFilter {
    final Map<String, List<String>> disabledEndpoints;

    public static Optional<OASFilter> maybeGetInstance() {
        Map endpoints = DisabledRestEndpoints.get();
        if (endpoints != null && !endpoints.isEmpty()) {
            return Optional.of(new DisabledRestEndpointsFilter(endpoints));
        }
        return Optional.empty();
    }

    private DisabledRestEndpointsFilter(Map<String, List<String>> disabledEndpoints) {
        this.disabledEndpoints = disabledEndpoints;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        Paths paths = openAPI.getPaths();
        this.disabledEndpoints.entrySet().stream().map(pathMethods -> Map.entry(DisabledRestEndpointsFilter.stripSlash((String)pathMethods.getKey()), (List)pathMethods.getValue())).filter(pathMethods -> paths.hasPathItem((String)pathMethods.getKey())).forEach(pathMethods -> {
            String path = (String)pathMethods.getKey();
            PathItem pathItem = paths.getPathItem(path);
            Optional.ofNullable((List)pathMethods.getValue()).orElseGet(Collections::emptyList).stream().map(PathItem.HttpMethod::valueOf).forEach(method -> pathItem.setOperation(method, null));
            if (pathItem.getOperations().isEmpty()) {
                paths.removePathItem(path);
            }
        });
    }

    static String stripSlash(String path) {
        if (path.endsWith("/") && path.length() > 1) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }
}

