/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.security.CreateRoleResponse;
import org.opensearch.client.opensearch.security.IndexPermission;
import org.opensearch.client.opensearch.security.TenantPermission;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class CreateRoleRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CreateRoleRequest> {
    @Nonnull
    private final List<String> clusterPermissions;
    @Nullable
    private final String description;
    @Nullable
    private final Boolean hidden;
    @Nonnull
    private final List<IndexPermission> indexPermissions;
    @Nullable
    private final Boolean reserved;
    @Nonnull
    private final String role;
    @Nullable
    private final Boolean static_;
    @Nonnull
    private final List<TenantPermission> tenantPermissions;
    public static final JsonpDeserializer<CreateRoleRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateRoleRequest::setupCreateRoleRequestDeserializer);
    public static final Endpoint<CreateRoleRequest, CreateRoleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateRoleRequest, CreateRoleResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_security/api/roles/");
        SimpleEndpoint.pathEncode(request.role, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateRoleResponse._DESERIALIZER);

    private CreateRoleRequest(Builder builder) {
        super(builder);
        this.clusterPermissions = ApiTypeHelper.unmodifiable(builder.clusterPermissions);
        this.description = builder.description;
        this.hidden = builder.hidden;
        this.indexPermissions = ApiTypeHelper.unmodifiable(builder.indexPermissions);
        this.reserved = builder.reserved;
        this.role = ApiTypeHelper.requireNonNull(builder.role, this, "role");
        this.static_ = builder.static_;
        this.tenantPermissions = ApiTypeHelper.unmodifiable(builder.tenantPermissions);
    }

    public static CreateRoleRequest of(Function<Builder, ObjectBuilder<CreateRoleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> clusterPermissions() {
        return this.clusterPermissions;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Boolean hidden() {
        return this.hidden;
    }

    @Nonnull
    public final List<IndexPermission> indexPermissions() {
        return this.indexPermissions;
    }

    @Nullable
    public final Boolean reserved() {
        return this.reserved;
    }

    @Nonnull
    public final String role() {
        return this.role;
    }

    @Nullable
    public final Boolean static_() {
        return this.static_;
    }

    @Nonnull
    public final List<TenantPermission> tenantPermissions() {
        return this.tenantPermissions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.clusterPermissions)) {
            generator.writeKey("cluster_permissions");
            generator.writeStartArray();
            for (String string : this.clusterPermissions) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.hidden != null) {
            generator.writeKey("hidden");
            generator.write(this.hidden.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.indexPermissions)) {
            generator.writeKey("index_permissions");
            generator.writeStartArray();
            for (IndexPermission indexPermission : this.indexPermissions) {
                indexPermission.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.reserved != null) {
            generator.writeKey("reserved");
            generator.write(this.reserved.booleanValue());
        }
        if (this.static_ != null) {
            generator.writeKey("static");
            generator.write(this.static_.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.tenantPermissions)) {
            generator.writeKey("tenant_permissions");
            generator.writeStartArray();
            for (TenantPermission tenantPermission : this.tenantPermissions) {
                tenantPermission.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCreateRoleRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::clusterPermissions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "cluster_permissions");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::hidden, JsonpDeserializer.booleanDeserializer(), "hidden");
        op.add(Builder::indexPermissions, JsonpDeserializer.arrayDeserializer(IndexPermission._DESERIALIZER), "index_permissions");
        op.add(Builder::reserved, JsonpDeserializer.booleanDeserializer(), "reserved");
        op.add(Builder::static_, JsonpDeserializer.booleanDeserializer(), "static");
        op.add(Builder::tenantPermissions, JsonpDeserializer.arrayDeserializer(TenantPermission._DESERIALIZER), "tenant_permissions");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.clusterPermissions);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.hidden);
        result = 31 * result + Objects.hashCode(this.indexPermissions);
        result = 31 * result + Objects.hashCode(this.reserved);
        result = 31 * result + this.role.hashCode();
        result = 31 * result + Objects.hashCode(this.static_);
        result = 31 * result + Objects.hashCode(this.tenantPermissions);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateRoleRequest other = (CreateRoleRequest)o;
        return Objects.equals(this.clusterPermissions, other.clusterPermissions) && Objects.equals(this.description, other.description) && Objects.equals(this.hidden, other.hidden) && Objects.equals(this.indexPermissions, other.indexPermissions) && Objects.equals(this.reserved, other.reserved) && this.role.equals(other.role) && Objects.equals(this.static_, other.static_) && Objects.equals(this.tenantPermissions, other.tenantPermissions);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CreateRoleRequest> {
        @Nullable
        private List<String> clusterPermissions;
        @Nullable
        private String description;
        @Nullable
        private Boolean hidden;
        @Nullable
        private List<IndexPermission> indexPermissions;
        @Nullable
        private Boolean reserved;
        private String role;
        @Nullable
        private Boolean static_;
        @Nullable
        private List<TenantPermission> tenantPermissions;

        public Builder() {
        }

        private Builder(CreateRoleRequest o) {
            super(o);
            this.clusterPermissions = Builder._listCopy(o.clusterPermissions);
            this.description = o.description;
            this.hidden = o.hidden;
            this.indexPermissions = Builder._listCopy(o.indexPermissions);
            this.reserved = o.reserved;
            this.role = o.role;
            this.static_ = o.static_;
            this.tenantPermissions = Builder._listCopy(o.tenantPermissions);
        }

        private Builder(Builder o) {
            super(o);
            this.clusterPermissions = Builder._listCopy(o.clusterPermissions);
            this.description = o.description;
            this.hidden = o.hidden;
            this.indexPermissions = Builder._listCopy(o.indexPermissions);
            this.reserved = o.reserved;
            this.role = o.role;
            this.static_ = o.static_;
            this.tenantPermissions = Builder._listCopy(o.tenantPermissions);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder clusterPermissions(List<String> list) {
            this.clusterPermissions = Builder._listAddAll(this.clusterPermissions, list);
            return this;
        }

        @Nonnull
        public final Builder clusterPermissions(String value, String ... values) {
            this.clusterPermissions = Builder._listAdd(this.clusterPermissions, value, values);
            return this;
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder hidden(@Nullable Boolean value) {
            this.hidden = value;
            return this;
        }

        @Nonnull
        public final Builder indexPermissions(List<IndexPermission> list) {
            this.indexPermissions = Builder._listAddAll(this.indexPermissions, list);
            return this;
        }

        @Nonnull
        public final Builder indexPermissions(IndexPermission value, IndexPermission ... values) {
            this.indexPermissions = Builder._listAdd(this.indexPermissions, value, values);
            return this;
        }

        @Nonnull
        public final Builder indexPermissions(Function<IndexPermission.Builder, ObjectBuilder<IndexPermission>> fn) {
            return this.indexPermissions(fn.apply(new IndexPermission.Builder()).build(), new IndexPermission[0]);
        }

        @Nonnull
        public final Builder reserved(@Nullable Boolean value) {
            this.reserved = value;
            return this;
        }

        @Nonnull
        public final Builder role(String value) {
            this.role = value;
            return this;
        }

        @Nonnull
        public final Builder static_(@Nullable Boolean value) {
            this.static_ = value;
            return this;
        }

        @Nonnull
        public final Builder tenantPermissions(List<TenantPermission> list) {
            this.tenantPermissions = Builder._listAddAll(this.tenantPermissions, list);
            return this;
        }

        @Nonnull
        public final Builder tenantPermissions(TenantPermission value, TenantPermission ... values) {
            this.tenantPermissions = Builder._listAdd(this.tenantPermissions, value, values);
            return this;
        }

        @Nonnull
        public final Builder tenantPermissions(Function<TenantPermission.Builder, ObjectBuilder<TenantPermission>> fn) {
            return this.tenantPermissions(fn.apply(new TenantPermission.Builder()).build(), new TenantPermission[0]);
        }

        @Override
        @Nonnull
        public CreateRoleRequest build() {
            this._checkSingleUse();
            return new CreateRoleRequest(this);
        }
    }
}

