/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal;

import java.time.Duration;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.crt.ConnectionHealthConfiguration;
import software.amazon.awssdk.http.crt.ProxyConfiguration;
import software.amazon.awssdk.http.crt.TcpKeepAliveConfiguration;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AwsCrtClientBuilderBase<BuilderT> {
    private final AttributeMap.Builder standardOptions = AttributeMap.builder();
    private Long readBufferSize;
    private ProxyConfiguration proxyConfiguration = ProxyConfiguration.builder().build();
    private ConnectionHealthConfiguration connectionHealthConfiguration;
    private TcpKeepAliveConfiguration tcpKeepAliveConfiguration;
    private Boolean postQuantumTlsEnabled;

    protected AwsCrtClientBuilderBase() {
    }

    protected AttributeMap.Builder getAttributeMap() {
        return this.standardOptions;
    }

    private BuilderT thisBuilder() {
        return (BuilderT)this;
    }

    public BuilderT maxConcurrency(Integer maxConcurrency) {
        Validate.isPositiveOrNull((Integer)maxConcurrency, (String)"maxConcurrency");
        this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)maxConcurrency);
        return this.thisBuilder();
    }

    public BuilderT readBufferSizeInBytes(Long readBufferSize) {
        Validate.isPositiveOrNull((Long)readBufferSize, (String)"readBufferSize");
        this.readBufferSize = readBufferSize;
        return this.thisBuilder();
    }

    public Long getReadBufferSizeInBytes() {
        return this.readBufferSize;
    }

    public BuilderT proxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        return this.thisBuilder();
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public BuilderT connectionHealthConfiguration(ConnectionHealthConfiguration monitoringOptions) {
        this.connectionHealthConfiguration = monitoringOptions;
        return this.thisBuilder();
    }

    public ConnectionHealthConfiguration getConnectionHealthConfiguration() {
        return this.connectionHealthConfiguration;
    }

    public BuilderT connectionHealthConfiguration(Consumer<ConnectionHealthConfiguration.Builder> configurationBuilder) {
        ConnectionHealthConfiguration.Builder builder = ConnectionHealthConfiguration.builder();
        configurationBuilder.accept(builder);
        this.connectionHealthConfiguration(builder.build());
        return this.thisBuilder();
    }

    public BuilderT connectionMaxIdleTime(Duration connectionMaxIdleTime) {
        Validate.isPositive((Duration)connectionMaxIdleTime, (String)"connectionMaxIdleTime");
        this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_MAX_IDLE_TIMEOUT, (Object)connectionMaxIdleTime);
        return this.thisBuilder();
    }

    public BuilderT connectionTimeout(Duration connectionTimeout) {
        Validate.isPositive((Duration)connectionTimeout, (String)"connectionTimeout");
        this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)connectionTimeout);
        return this.thisBuilder();
    }

    public BuilderT connectionAcquisitionTimeout(Duration connectionAcquisitionTimeout) {
        Validate.isPositive((Duration)connectionAcquisitionTimeout, (String)"connectionAcquisitionTimeout");
        this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT, (Object)connectionAcquisitionTimeout);
        return this.thisBuilder();
    }

    public BuilderT tcpKeepAliveConfiguration(TcpKeepAliveConfiguration tcpKeepAliveConfiguration) {
        this.tcpKeepAliveConfiguration = tcpKeepAliveConfiguration;
        return this.thisBuilder();
    }

    public TcpKeepAliveConfiguration getTcpKeepAliveConfiguration() {
        return this.tcpKeepAliveConfiguration;
    }

    public BuilderT tcpKeepAliveConfiguration(Consumer<TcpKeepAliveConfiguration.Builder> tcpKeepAliveConfigurationBuilder) {
        TcpKeepAliveConfiguration.Builder builder = TcpKeepAliveConfiguration.builder();
        tcpKeepAliveConfigurationBuilder.accept(builder);
        this.tcpKeepAliveConfiguration(builder.build());
        return this.thisBuilder();
    }

    public BuilderT postQuantumTlsEnabled(Boolean postQuantumTlsEnabled) {
        this.postQuantumTlsEnabled = postQuantumTlsEnabled;
        return this.thisBuilder();
    }

    public Boolean getPostQuantumTlsEnabled() {
        return this.postQuantumTlsEnabled;
    }

    public BuilderT proxyConfiguration(Consumer<ProxyConfiguration.Builder> proxyConfigurationBuilderConsumer) {
        ProxyConfiguration.Builder builder = ProxyConfiguration.builder();
        proxyConfigurationBuilderConsumer.accept(builder);
        this.proxyConfiguration(builder.build());
        return this.thisBuilder();
    }
}

